/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.listeners;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.ShallowDocumentModel;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.TemplateProcessorService;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;

public class TemplateTypeBindingListener
implements PostCommitEventListener {
    protected static Log log = LogFactory.getLog(TemplateTypeBindingListener.class);

    public void handleEvent(EventBundle eventBundle) throws ClientException {
        if (eventBundle.containsEventName("documentCreated") || eventBundle.containsEventName("documentModified")) {
            TemplateProcessorService tps = (TemplateProcessorService)Framework.getLocalService(TemplateProcessorService.class);
            for (Event event : eventBundle) {
                DocumentEventContext docCtx;
                DocumentModel targetDoc;
                EventContext ctx;
                if (!"documentCreated".equals(event.getName()) && !"documentModified".equals(event.getName()) || !((ctx = event.getContext()) instanceof DocumentEventContext) || (targetDoc = (docCtx = (DocumentEventContext)ctx).getSourceDocument()).isVersion()) continue;
                if (targetDoc instanceof ShallowDocumentModel) {
                    log.warn((Object)("Skip unconnected document with type " + targetDoc.getType() + " and path " + targetDoc.getPathAsString()));
                    continue;
                }
                try {
                    TemplateSourceDocument tmpl = (TemplateSourceDocument)targetDoc.getAdapter(TemplateSourceDocument.class);
                    if (tmpl == null) continue;
                    tps.registerTypeMapping(targetDoc);
                    targetDoc.getCoreSession().save();
                }
                catch (Throwable e) {
                    log.warn((Object)"Unable to get adapter to check type binding", e);
                }
            }
        }
    }
}

