/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.template.api.TemplateProcessor;
import org.nuxeo.template.api.TemplateProcessorService;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;
import org.nuxeo.template.api.context.ContextExtensionFactory;
import org.nuxeo.template.api.context.DocumentWrapper;
import org.nuxeo.template.api.descriptor.ContextExtensionFactoryDescriptor;
import org.nuxeo.template.api.descriptor.TemplateProcessorDescriptor;
import org.nuxeo.template.context.AbstractContextBuilder;
import org.nuxeo.template.fm.FreeMarkerVariableExtractor;
import org.nuxeo.template.service.ContextFactoryRegistry;
import org.nuxeo.template.service.TemplateMappingFetcher;
import org.nuxeo.template.service.TemplateProcessorRegistry;

public class TemplateProcessorComponent
extends DefaultComponent
implements TemplateProcessorService {
    protected static final Log log = LogFactory.getLog(TemplateProcessorComponent.class);
    public static final String PROCESSOR_XP = "processor";
    public static final String CONTEXT_EXTENSION_XP = "contextExtension";
    protected ContextFactoryRegistry contextExtensionRegistry;
    protected TemplateProcessorRegistry processorRegistry;
    protected ConcurrentHashMap<String, List<String>> type2Template = null;

    public void activate(ComponentContext context) throws Exception {
        this.processorRegistry = new TemplateProcessorRegistry();
        this.contextExtensionRegistry = new ContextFactoryRegistry();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.processorRegistry = null;
        this.contextExtensionRegistry = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (PROCESSOR_XP.equals(extensionPoint)) {
            this.processorRegistry.addContribution((TemplateProcessorDescriptor)contribution);
        } else if (CONTEXT_EXTENSION_XP.equals(extensionPoint)) {
            this.contextExtensionRegistry.addContribution((ContextExtensionFactoryDescriptor)contribution);
            FreeMarkerVariableExtractor.resetReservedContextKeywords();
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (PROCESSOR_XP.equals(extensionPoint)) {
            this.processorRegistry.removeContribution((TemplateProcessorDescriptor)contribution);
        } else if (CONTEXT_EXTENSION_XP.equals(extensionPoint)) {
            this.contextExtensionRegistry.removeContribution((ContextExtensionFactoryDescriptor)contribution);
        }
    }

    public TemplateProcessor findProcessor(Blob templateBlob) {
        TemplateProcessorDescriptor desc = this.findProcessorDescriptor(templateBlob);
        if (desc != null) {
            return desc.getProcessor();
        }
        return null;
    }

    public String findProcessorName(Blob templateBlob) {
        TemplateProcessorDescriptor desc = this.findProcessorDescriptor(templateBlob);
        if (desc != null) {
            return desc.getName();
        }
        return null;
    }

    public TemplateProcessorDescriptor findProcessorDescriptor(Blob templateBlob) {
        String fileName;
        TemplateProcessorDescriptor processor = null;
        String mt = templateBlob.getMimeType();
        if (mt != null) {
            processor = this.findProcessorByMimeType(mt);
        }
        if (processor == null && (fileName = templateBlob.getFilename()) != null) {
            String ext = FileUtils.getFileExtension((String)fileName);
            processor = this.findProcessorByExtension(ext);
        }
        return processor;
    }

    public void addContextExtensions(DocumentModel currentDocument, DocumentWrapper wrapper, Map<String, Object> ctx) {
        Map<String, ContextExtensionFactoryDescriptor> factories = this.contextExtensionRegistry.getExtensionFactories();
        for (String name : factories.keySet()) {
            Object ob;
            ContextExtensionFactory factory = factories.get(name).getExtensionFactory();
            if (factory == null || (ob = factory.getExtension(currentDocument, wrapper, ctx)) == null) continue;
            ctx.put(name, ob);
            for (String alias : factories.get(name).getAliases()) {
                ctx.put(alias, ob);
            }
        }
    }

    public List<String> getReservedContextKeywords() {
        ArrayList<String> keywords = new ArrayList<String>();
        Map<String, ContextExtensionFactoryDescriptor> factories = this.contextExtensionRegistry.getExtensionFactories();
        for (String name : factories.keySet()) {
            keywords.add(name);
            keywords.addAll(factories.get(name).getAliases());
        }
        for (String keyword : AbstractContextBuilder.RESERVED_VAR_NAMES) {
            keywords.add(keyword);
        }
        return keywords;
    }

    public Map<String, ContextExtensionFactoryDescriptor> getRegistredContextExtensions() {
        return this.contextExtensionRegistry.getExtensionFactories();
    }

    protected TemplateProcessorDescriptor findProcessorByMimeType(String mt) {
        ArrayList<TemplateProcessorDescriptor> candidates = new ArrayList<TemplateProcessorDescriptor>();
        for (TemplateProcessorDescriptor desc : this.processorRegistry.getRegistredProcessors()) {
            if (!desc.getSupportedMimeTypes().contains(mt)) continue;
            if (desc.isDefaultProcessor()) {
                return desc;
            }
            candidates.add(desc);
        }
        if (candidates.size() > 0) {
            return (TemplateProcessorDescriptor)candidates.get(0);
        }
        return null;
    }

    protected TemplateProcessorDescriptor findProcessorByExtension(String extension) {
        ArrayList<TemplateProcessorDescriptor> candidates = new ArrayList<TemplateProcessorDescriptor>();
        for (TemplateProcessorDescriptor desc : this.processorRegistry.getRegistredProcessors()) {
            if (!desc.getSupportedExtensions().contains(extension)) continue;
            if (desc.isDefaultProcessor()) {
                return desc;
            }
            candidates.add(desc);
        }
        if (candidates.size() > 0) {
            return (TemplateProcessorDescriptor)candidates.get(0);
        }
        return null;
    }

    public TemplateProcessorDescriptor getDescriptor(String name) {
        return this.processorRegistry.getProcessorByName(name);
    }

    public TemplateProcessor getProcessor(String name) {
        TemplateProcessorDescriptor desc;
        if (name == null) {
            log.info((Object)"no defined processor name, using Identity as default");
            name = "Identity";
        }
        if ((desc = this.processorRegistry.getProcessorByName(name)) != null) {
            return desc.getProcessor();
        }
        log.warn((Object)("Can not get a TemplateProcessor with name " + name));
        return null;
    }

    protected String buildTemplateSearchQuery(String targetType) {
        StringBuffer sb = new StringBuffer("select * from Document where ecm:mixinType = 'Template' AND ecm:currentLifeCycleState != 'deleted'");
        if (targetType != null) {
            sb.append(" AND tmpl:applicableTypes IN ( 'all', '" + targetType + "')");
        }
        return sb.toString();
    }

    public List<DocumentModel> getAvailableTemplateDocs(CoreSession session, String targetType) throws ClientException {
        String query = this.buildTemplateSearchQuery(targetType);
        return session.query(query);
    }

    protected <T> List<T> wrap(List<DocumentModel> docs, Class<T> adapter) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (DocumentModel doc : docs) {
            Object adapted = doc.getAdapter(adapter);
            if (adapted == null) continue;
            result.add(adapted);
        }
        return result;
    }

    public List<TemplateSourceDocument> getAvailableOfficeTemplates(CoreSession session, String targetType) throws ClientException {
        String query = this.buildTemplateSearchQuery(targetType);
        query = query + " AND tmpl:useAsMainContent=1";
        DocumentModelList docs = session.query(query);
        return this.wrap((List<DocumentModel>)docs, TemplateSourceDocument.class);
    }

    public List<TemplateSourceDocument> getAvailableTemplates(CoreSession session, String targetType) throws ClientException {
        List<DocumentModel> filtredResult = this.getAvailableTemplateDocs(session, targetType);
        return this.wrap(filtredResult, TemplateSourceDocument.class);
    }

    public List<TemplateBasedDocument> getLinkedTemplateBasedDocuments(DocumentModel source) throws ClientException {
        StringBuffer sb = new StringBuffer("select * from Document where ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0 AND ");
        sb.append("nxts:bindings/*/templateId");
        sb.append(" = '");
        sb.append(source.getId());
        sb.append("'");
        DocumentModelList docs = source.getCoreSession().query(sb.toString());
        ArrayList<TemplateBasedDocument> result = new ArrayList<TemplateBasedDocument>();
        for (DocumentModel doc : docs) {
            TemplateBasedDocument templateBasedDocument = (TemplateBasedDocument)doc.getAdapter(TemplateBasedDocument.class);
            if (templateBasedDocument == null) continue;
            result.add(templateBasedDocument);
        }
        return result;
    }

    public Collection<TemplateProcessorDescriptor> getRegisteredTemplateProcessors() {
        return this.processorRegistry.getRegistredProcessors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getTypeMapping() {
        if (this.type2Template == null) {
            TemplateProcessorComponent templateProcessorComponent = this;
            synchronized (templateProcessorComponent) {
                if (this.type2Template == null) {
                    this.type2Template = new ConcurrentHashMap();
                    TemplateMappingFetcher fetcher = new TemplateMappingFetcher();
                    try {
                        fetcher.runUnrestricted();
                    }
                    catch (ClientException e) {
                        log.error((Object)"Unable to fetch templates 2 types mapping", (Throwable)e);
                    }
                    this.type2Template.putAll(fetcher.getMapping());
                }
            }
        }
        return this.type2Template;
    }

    public synchronized void registerTypeMapping(DocumentModel doc) throws ClientException {
        TemplateSourceDocument tmpl = (TemplateSourceDocument)doc.getAdapter(TemplateSourceDocument.class);
        if (tmpl != null) {
            List<String> templates;
            Map<String, List<String>> mapping = this.getTypeMapping();
            ArrayList<String> boundTypes = new ArrayList<String>();
            for (String type : mapping.keySet()) {
                if (mapping.get(type) == null || !mapping.get(type).contains(doc.getId())) continue;
                boundTypes.add(type);
            }
            for (String type : boundTypes) {
                templates = mapping.get(type);
                templates.remove(doc.getId());
                if (templates.size() != 0) continue;
                mapping.remove(type);
            }
            for (String type : tmpl.getForcedTypes()) {
                templates = mapping.get(type);
                if (templates == null) {
                    templates = new ArrayList<String>();
                    mapping.put(type, templates);
                }
                if (templates.contains(doc.getId())) continue;
                templates.add(doc.getId());
            }
        }
    }

    public DocumentModel makeTemplateBasedDocument(DocumentModel targetDoc, DocumentModel sourceTemplateDoc, boolean save) throws ClientException {
        targetDoc.addFacet("TemplateBased");
        TemplateBasedDocument tmplBased = (TemplateBasedDocument)targetDoc.getAdapter(TemplateBasedDocument.class);
        return tmplBased.setTemplate(sourceTemplateDoc, save);
    }

    public DocumentModel detachTemplateBasedDocument(DocumentModel targetDoc, String templateName, boolean save) throws ClientException {
        DocumentModel docAfterDetach = null;
        TemplateBasedDocument tbd = (TemplateBasedDocument)targetDoc.getAdapter(TemplateBasedDocument.class);
        if (tbd != null) {
            if (!tbd.getTemplateNames().contains(templateName)) {
                return targetDoc;
            }
            if (tbd.getTemplateNames().size() == 1) {
                targetDoc.removeFacet("TemplateBased");
                log.error((Object)("detach after removeFacet, ck=" + targetDoc.getCacheKey()));
                if (save) {
                    docAfterDetach = targetDoc.getCoreSession().saveDocument(targetDoc);
                }
            } else {
                docAfterDetach = tbd.removeTemplateBinding(templateName, true);
            }
        }
        if (docAfterDetach != null) {
            return docAfterDetach;
        }
        return targetDoc;
    }
}

