/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors.docx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.tree.DefaultElement;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.InputType;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.processors.AbstractTemplateProcessor;
import org.nuxeo.template.processors.BidirectionalTemplateProcessor;

public class WordXMLRawTemplateProcessor
extends AbstractTemplateProcessor
implements BidirectionalTemplateProcessor {
    public static final String WORD_XML_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String TEMPLATE_TYPE = "wordXMLTemplate";

    public Blob renderTemplate(TemplateBasedDocument templateDocument, String templateName) throws IOException {
        Document xmlDoc;
        File workingDir = this.getWorkingDir();
        Blob blob = templateDocument.getTemplateBlob(templateName);
        String fileName = blob.getFilename();
        List params = templateDocument.getParams(templateName);
        try (CloseableFile source = blob.getCloseableFile();){
            ZipUtils.unzip((File)source.getFile(), (File)workingDir);
        }
        File xmlCustomFile = new File(workingDir.getAbsolutePath() + "/docProps/custom.xml");
        String xmlContent = FileUtils.readFileToString((File)xmlCustomFile, (Charset)StandardCharsets.UTF_8);
        try {
            xmlDoc = DocumentHelper.parseText((String)xmlContent);
        }
        catch (DocumentException e) {
            throw new IOException(e);
        }
        List nodes = xmlDoc.getRootElement().elements();
        for (Object node : nodes) {
            DefaultElement elem = (DefaultElement)node;
            if (!"property".equals(elem.getName())) continue;
            String name = elem.attributeValue("name");
            TemplateInput param = this.getParamByName(name, params);
            DefaultElement valueElem = (DefaultElement)elem.elements().get(0);
            String strValue = "";
            if (param.isSourceValue()) {
                Serializable value;
                Property property = templateDocument.getAdaptedDoc().getProperty(param.getSource());
                if (property != null && (value = templateDocument.getAdaptedDoc().getPropertyValue(param.getSource())) != null) {
                    if (value instanceof Date) {
                        SimpleDateFormat wordXMLDateFormat = new SimpleDateFormat(WORD_XML_DATE_FORMAT);
                        strValue = wordXMLDateFormat.format((Date)value);
                    } else {
                        strValue = value.toString();
                    }
                }
            } else if (InputType.StringValue.equals((Object)param.getType())) {
                strValue = param.getStringValue();
            } else if (InputType.BooleanValue.equals((Object)param.getType())) {
                strValue = param.getBooleanValue().toString();
            } else if (InputType.DateValue.equals((Object)param.getType())) {
                SimpleDateFormat wordXMLDateFormat = new SimpleDateFormat(WORD_XML_DATE_FORMAT);
                strValue = wordXMLDateFormat.format(param.getDateValue());
            }
            valueElem.setText(strValue);
        }
        String newXMLContent = xmlDoc.asXML();
        File newZipFile = Framework.createTempFile((String)"newWordXMLTemplate", (String)".docx");
        xmlCustomFile.delete();
        File newXMLFile = new File(xmlCustomFile.getAbsolutePath());
        FileUtils.writeStringToFile((File)newXMLFile, (String)newXMLContent, (Charset)StandardCharsets.UTF_8);
        File[] files = workingDir.listFiles();
        ZipUtils.zip((File[])files, (File)newZipFile);
        FileUtils.deleteDirectory((File)workingDir);
        Blob newBlob = Blobs.createBlob((File)newZipFile);
        Framework.trackFile((File)newZipFile, (Object)newBlob);
        newBlob.setFilename(fileName);
        return newBlob;
    }

    public List<TemplateInput> getInitialParametersDefinition(Blob blob) throws IOException {
        Document xmlDoc;
        ArrayList<TemplateInput> params = new ArrayList<TemplateInput>();
        String xmlContent = this.readPropertyFile(blob.getStream());
        try {
            xmlDoc = DocumentHelper.parseText((String)xmlContent);
        }
        catch (DocumentException e) {
            throw new IOException(e);
        }
        List nodes = xmlDoc.getRootElement().elements();
        for (Object node : nodes) {
            DefaultElement elem = (DefaultElement)node;
            if (!"property".equals(elem.getName())) continue;
            String name = elem.attributeValue("name");
            DefaultElement valueElem = (DefaultElement)elem.elements().get(0);
            String wordType = valueElem.getName();
            InputType nxType = InputType.StringValue;
            if (wordType.contains("lpwstr")) {
                nxType = InputType.StringValue;
            } else if (wordType.contains("filetime")) {
                nxType = InputType.DateValue;
            } else if (wordType.contains("bool")) {
                nxType = InputType.BooleanValue;
            }
            TemplateInput input = new TemplateInput(name);
            input.setType(nxType);
            params.add(input);
        }
        return params;
    }

    protected TemplateInput getParamByName(String name, List<TemplateInput> params) {
        for (TemplateInput param : params) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public String readPropertyFile(InputStream in) throws IOException {
        ZipInputStream zIn = new ZipInputStream(in);
        ZipEntry zipEntry = zIn.getNextEntry();
        String xmlContent = null;
        while (zipEntry != null) {
            if (zipEntry.getName().equals("docProps/custom.xml")) {
                int read;
                StringBuilder sb = new StringBuilder();
                byte[] buffer = new byte[65536];
                while ((read = zIn.read(buffer)) != -1) {
                    sb.append(new String(buffer, 0, read));
                }
                xmlContent = sb.toString();
                break;
            }
            zipEntry = zIn.getNextEntry();
        }
        zIn.close();
        return xmlContent;
    }

    public DocumentModel updateDocumentFromBlob(TemplateBasedDocument templateDocument, String templateName) throws IOException {
        Document xmlDoc;
        Blob blob = templateDocument.getTemplateBlob(templateName);
        String xmlContent = this.readPropertyFile(blob.getStream());
        if (xmlContent == null) {
            return templateDocument.getAdaptedDoc();
        }
        try {
            xmlDoc = DocumentHelper.parseText((String)xmlContent);
        }
        catch (DocumentException e) {
            throw new IOException(e);
        }
        List nodes = xmlDoc.getRootElement().elements();
        DocumentModel adaptedDoc = templateDocument.getAdaptedDoc();
        List params = templateDocument.getParams(templateName);
        for (Object node : nodes) {
            SimpleDateFormat wordXMLDateFormat;
            DefaultElement elem = (DefaultElement)node;
            if (!"property".equals(elem.getName())) continue;
            String name = elem.attributeValue("name");
            TemplateInput param = this.getParamByName(name, params);
            DefaultElement valueElem = (DefaultElement)elem.elements().get(0);
            String xmlValue = valueElem.getTextTrim();
            if (param.isSourceValue()) {
                if (InputType.StringValue.equals((Object)param.getType())) {
                    adaptedDoc.setPropertyValue(param.getSource(), (Serializable)((Object)xmlValue));
                    continue;
                }
                if (InputType.BooleanValue.equals((Object)param.getType())) {
                    adaptedDoc.setPropertyValue(param.getSource(), (Serializable)Boolean.valueOf(xmlValue));
                    continue;
                }
                if (!InputType.DateValue.equals((Object)param.getType())) continue;
                wordXMLDateFormat = new SimpleDateFormat(WORD_XML_DATE_FORMAT);
                try {
                    adaptedDoc.setPropertyValue(param.getSource(), (Serializable)wordXMLDateFormat.parse(xmlValue));
                    continue;
                }
                catch (ParseException | PropertyException e) {
                    throw new IOException(e);
                }
            }
            if (InputType.StringValue.equals((Object)param.getType())) {
                param.setStringValue(xmlValue);
                continue;
            }
            if (InputType.BooleanValue.equals((Object)param.getType())) {
                param.setBooleanValue(Boolean.valueOf(xmlValue));
                continue;
            }
            if (!InputType.DateValue.equals((Object)param.getType())) continue;
            wordXMLDateFormat = new SimpleDateFormat(WORD_XML_DATE_FORMAT);
            try {
                param.setDateValue(wordXMLDateFormat.parse(xmlValue));
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        adaptedDoc = templateDocument.saveParams(templateName, params, false);
        return adaptedDoc;
    }
}

