/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.importer;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.runtime.api.Framework;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class TemplateBundleActivator
implements BundleActivator {
    private BundleContext context;
    protected static final Log log = LogFactory.getLog(TemplateBundleActivator.class);

    protected static String getTemplateResourcesRootPath() {
        return "templatesamples";
    }

    public URL getResource(String path) {
        return this.context.getBundle().getResource(path);
    }

    public Enumeration findEntries(String path) {
        return this.context.getBundle().findEntries(path, null, true);
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.expandResources();
    }

    public void stop(BundleContext context) throws Exception {
        this.context = null;
    }

    protected static Path getDataDirPath() {
        String dataDir = null;
        dataDir = Framework.isTestModeSet() ? "/tmp" : Framework.getProperty((String)"nuxeo.data.dir");
        Path path = new Path(dataDir);
        path = path.append("resources");
        return path;
    }

    public void expandResources() throws Exception {
        log.info((Object)("Deploying templates for bundle " + this.context.getBundle().getSymbolicName()));
        URL sampleRootURL = this.getResource(TemplateBundleActivator.getTemplateResourcesRootPath());
        if (sampleRootURL == null) {
            return;
        }
        Path path = TemplateBundleActivator.getDataDirPath();
        File dataDir = new File((path = path.append(TemplateBundleActivator.getTemplateResourcesRootPath())).toString());
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        Enumeration urls = this.findEntries(TemplateBundleActivator.getTemplateResourcesRootPath());
        while (urls.hasMoreElements()) {
            URL resourceURL = (URL)urls.nextElement();
            InputStream is = resourceURL.openStream();
            String filePath = resourceURL.getFile();
            filePath = filePath.split("/" + TemplateBundleActivator.getTemplateResourcesRootPath() + "/")[1];
            filePath = "/" + filePath;
            File f = new File(dataDir, filePath);
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            FileUtils.copyToFile((InputStream)is, (File)f);
            is.close();
        }
    }
}

