/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors.fm;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.rendering.fm.FreemarkerEngine;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.TemplateProcessor;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.fm.FMContextBuilder;
import org.nuxeo.template.fm.FreeMarkerVariableExtractor;
import org.nuxeo.template.processors.AbstractTemplateProcessor;
import org.nuxeo.template.processors.fm.FMBindingResolver;

public class FreeMarkerProcessor
extends AbstractTemplateProcessor
implements TemplateProcessor {
    protected StringTemplateLoader loader = new StringTemplateLoader();
    protected FreemarkerEngine fmEngine = null;
    protected FMContextBuilder fmContextBuilder = new FMContextBuilder();
    protected static final Pattern XMLStartPattern = Pattern.compile("<\\?xml");
    protected static final Pattern HtmlTagPattern = Pattern.compile("<(\\S+?)(.*?)>(.*?)</\\1>", 42);

    protected FreemarkerEngine getEngine() {
        if (this.fmEngine == null) {
            this.fmEngine = new FreemarkerEngine();
            this.fmEngine.getConfiguration().setTemplateLoader((TemplateLoader)this.loader);
        }
        return this.fmEngine;
    }

    protected String guessMimeType(StringBlob result, MimetypeRegistry mreg) throws Exception {
        if (result == null) {
            return null;
        }
        String content = result.getString();
        if (XMLStartPattern.matcher(content).find()) {
            return "text/xml";
        }
        if (HtmlTagPattern.matcher(content).find()) {
            return "text/html";
        }
        return mreg.getMimetypeFromBlobWithDefault((Blob)result, "text/plain");
    }

    protected void setBlobAttributes(StringBlob result, TemplateBasedDocument templateBasedDocument) throws Exception {
        List extensions;
        String found_mimetype;
        MimetypeRegistry mreg = (MimetypeRegistry)Framework.getLocalService(MimetypeRegistry.class);
        String mimetype = "text/html";
        String extension = ".html";
        if (mreg != null && (found_mimetype = this.guessMimeType(result, mreg)) != null && (extensions = mreg.getExtensionsFromMimetypeName(mimetype = found_mimetype)) != null && extensions.size() > 0) {
            extension = "." + (String)extensions.get(0);
        }
        if ("text/xml".equalsIgnoreCase(mimetype)) {
            extension = ".xml";
        }
        result.setMimeType(mimetype);
        String targetFileName = FileUtils.getFileNameNoExt((String)templateBasedDocument.getAdaptedDoc().getTitle());
        result.setFilename(targetFileName + extension);
    }

    public Blob renderTemplate(TemplateBasedDocument templateBasedDocument, String templateName) throws Exception {
        Blob sourceTemplateBlob = this.getSourceTemplateBlob(templateBasedDocument, templateName);
        String fmTemplateKey = "main" + System.currentTimeMillis();
        String ftl = sourceTemplateBlob.getString();
        this.loader.putTemplate(fmTemplateKey, ftl);
        Map<String, Object> ctx = this.fmContextBuilder.build(templateBasedDocument, templateName);
        FMBindingResolver resolver = new FMBindingResolver();
        resolver.resolve(templateBasedDocument.getParams(templateName), ctx, templateBasedDocument);
        StringWriter writer = new StringWriter();
        this.getEngine().render(fmTemplateKey, ctx, (Writer)writer);
        StringBlob result = new StringBlob(writer.toString());
        this.setBlobAttributes(result, templateBasedDocument);
        return result;
    }

    public List<TemplateInput> getInitialParametersDefinition(Blob blob) throws Exception {
        String xmlContent;
        ArrayList<TemplateInput> params = new ArrayList<TemplateInput>();
        if (blob != null && (xmlContent = blob.getString()) != null) {
            List<String> vars = FreeMarkerVariableExtractor.extractVariables(xmlContent);
            for (String var : vars) {
                TemplateInput input = new TemplateInput(var);
                params.add(input);
            }
        }
        return params;
    }
}

