/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.core.document;

public enum ImageFormat {
    bmp("bmp"),
    jpg("jpeg"),
    jpeg("jpeg"),
    jpe("jpeg"),
    jfif("jpeg"),
    gif("gif"),
    tif("tiff"),
    tiff("tiff"),
    png("png");

    private final String type;

    private ImageFormat(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static ImageFormat getFormatByExtension(String extension) {
        if (extension == null) {
            return null;
        }
        extension = extension.toLowerCase();
        ImageFormat format = null;
        for (int i = 0; i < ImageFormat.values().length; ++i) {
            format = ImageFormat.values()[i];
            if (!format.name().equals(extension)) continue;
            return format;
        }
        return null;
    }

    public static ImageFormat getFormatByResourceName(String resourceName) {
        String extension = resourceName;
        int extensionIndex = resourceName.lastIndexOf(46);
        if (extensionIndex != -1) {
            extension = resourceName.substring(extensionIndex + 1, resourceName.length());
        }
        return ImageFormat.getFormatByExtension(extension);
    }
}

