/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.core.utils;

import fr.opensagres.xdocreport.core.EncodingConstants;
import fr.opensagres.xdocreport.core.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMUtils {
    public static Document load(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(stream);
    }

    public static Document load(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(IOUtils.toInputStream(xml, EncodingConstants.UTF_8.name()));
    }

    public static void save(Node node, Writer writer) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
    }

    public static void save(Node node, OutputStream out) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
    }

    public static Element getFirstChildElementByTagName(Node parentNode, String elementName) {
        Element result;
        block2: {
            block1: {
                result = null;
                if (parentNode.getNodeType() != 9) break block1;
                result = ((Document)parentNode).getDocumentElement();
                if (result.getNodeName().equals(elementName)) break block2;
                result = null;
                break block2;
            }
            NodeList nodes = parentNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals(elementName)) continue;
                result = (Element)node;
                break;
            }
        }
        return result;
    }

    public static Collection<Element> getFirstChildElementsByTagName(Node contextNode, String elementName) {
        ArrayList<Element> elements = null;
        Element result = null;
        if (contextNode.getNodeType() == 9) {
            result = ((Document)contextNode).getDocumentElement();
            if (!result.getNodeName().equals(elementName)) {
                result = null;
            }
        } else {
            NodeList nodes = contextNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals(elementName)) continue;
                if (elements == null) {
                    elements = new ArrayList<Element>();
                }
                result = (Element)node;
                elements.add(result);
            }
        }
        if (elements == null) {
            return Collections.emptyList();
        }
        return elements;
    }
}

