/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.adapters.doc;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentException;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.XMLSerializer;
import org.nuxeo.template.adapters.AbstractTemplateDocument;
import org.nuxeo.template.adapters.doc.TemplateBinding;
import org.nuxeo.template.adapters.doc.TemplateBindings;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.TemplateProcessor;
import org.nuxeo.template.api.TemplateProcessorService;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;
import org.nuxeo.template.api.descriptor.OutputFormatDescriptor;

public class TemplateBasedDocumentAdapterImpl
extends AbstractTemplateDocument
implements Serializable,
TemplateBasedDocument {
    private static final long serialVersionUID = 1L;
    public static final String TEMPLATEBASED_FACET = "TemplateBased";
    protected final TemplateBindings bindings;

    public TemplateBasedDocumentAdapterImpl(DocumentModel doc) {
        this.adaptedDoc = doc;
        this.bindings = new TemplateBindings(doc);
    }

    public DocumentModel setTemplate(DocumentModel template, boolean save) {
        TemplateSourceDocument source = (TemplateSourceDocument)template.getAdapter(TemplateSourceDocument.class);
        if (source == null) {
            throw new NuxeoException("Can not bind to an non template document");
        }
        String tid = source.getId();
        String templateName = source.getName();
        if (!this.bindings.containsTemplateId(tid)) {
            if (templateName == null) {
                templateName = "default";
            }
            TemplateBinding tb = new TemplateBinding();
            tb.setTemplateId(tid);
            tb.setName(templateName);
            this.bindings.add(tb);
            this.initializeFromTemplate(templateName, false);
            this.bindings.save(this.adaptedDoc);
            if (save) {
                this.doSave();
            }
        }
        return this.adaptedDoc;
    }

    public DocumentModel removeTemplateBinding(String templateName, boolean save) {
        if (this.bindings.containsTemplateName(templateName)) {
            this.bindings.removeByName(templateName);
            this.bindings.save(this.adaptedDoc);
            if (save) {
                this.doSave();
            }
        }
        return this.adaptedDoc;
    }

    public TemplateSourceDocument getSourceTemplate(String templateName) {
        DocumentModel template = this.getSourceTemplateDoc(templateName);
        if (template != null) {
            return (TemplateSourceDocument)template.getAdapter(TemplateSourceDocument.class);
        }
        return null;
    }

    public DocumentRef getSourceTemplateDocRef(String templateName) {
        TemplateBinding binding = null;
        binding = templateName == null ? this.bindings.get() : this.bindings.get(templateName);
        if (binding == null) {
            return null;
        }
        return new IdRef(binding.getTemplateId());
    }

    public DocumentModel getSourceTemplateDoc(String templateName) {
        TemplateBinding binding = null;
        binding = templateName == null ? this.bindings.get() : this.bindings.get(templateName);
        if (binding == null) {
            return null;
        }
        DocumentRef tRef = this.getSourceTemplateDocRef(templateName);
        if (tRef == null) {
            return null;
        }
        try {
            return this.getSession().getDocument(tRef);
        }
        catch (DocumentSecurityException e) {
            return null;
        }
    }

    public List<TemplateSourceDocument> getSourceTemplates() {
        ArrayList<TemplateSourceDocument> result = new ArrayList<TemplateSourceDocument>();
        for (TemplateBinding binding : this.bindings) {
            TemplateSourceDocument template = this.getSourceTemplate(binding.getName());
            if (template == null) continue;
            result.add(template);
        }
        return result;
    }

    public String getTemplateType(String templateName) {
        TemplateSourceDocument source = this.getSourceTemplate(templateName);
        if (source != null) {
            return source.getTemplateType();
        }
        return null;
    }

    public DocumentModel initializeFromTemplate(boolean save) {
        return this.initializeFromTemplate("default", save);
    }

    public DocumentModel initializeFromTemplate(String templateName, boolean save) {
        TemplateSourceDocument tmpl = this.getSourceTemplate(templateName);
        if (tmpl == null) {
            throw new NuxeoException("No associated template for name " + templateName);
        }
        List params = tmpl.getParams();
        ArrayList<TemplateInput> myParams = new ArrayList<TemplateInput>();
        for (TemplateInput param : params) {
            boolean readOnly = param.isSet() && !tmpl.allowInstanceOverride();
            TemplateInput myParam = param.getCopy(readOnly);
            myParams.add(myParam);
        }
        this.bindings.get(templateName).setData(myParams);
        if (tmpl.useAsMainContent()) {
            BlobHolder bh = (BlobHolder)this.adaptedDoc.getAdapter(BlobHolder.class);
            if (bh != null) {
                bh.setBlob(tmpl.getTemplateBlob());
            }
            this.bindings.get(templateName).setUseMainContentAsTemplate(true);
        }
        if (save) {
            this.doSave();
        }
        return this.adaptedDoc;
    }

    @Override
    protected void doSave() {
        this.bindings.save(this.adaptedDoc);
        super.doSave();
    }

    protected void setBlob(Blob blob) {
        ((BlobHolder)this.adaptedDoc.getAdapter(BlobHolder.class)).setBlob(blob);
    }

    public Blob renderWithTemplate(String templateName) {
        TemplateProcessor processor = this.getTemplateProcessor(templateName);
        if (processor != null) {
            Blob blob;
            try {
                blob = processor.renderTemplate((TemplateBasedDocument)this, templateName);
            }
            catch (IOException e) {
                throw new NuxeoException("Failed to render template: " + templateName, (Throwable)e);
            }
            TemplateSourceDocument template = this.getSourceTemplate(templateName);
            if (template == null) {
                throw new NuxeoException("No associated template for name " + templateName);
            }
            String format = template.getOutputFormat();
            if (blob != null && format != null && !format.isEmpty()) {
                try {
                    return this.convertBlob(templateName, blob, format);
                }
                catch (OperationException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
            return blob;
        }
        String templateType = this.getTemplateType(templateName);
        if (templateType == null) {
            throw new NuxeoException("Template type is null : if you don't set it explicitly, your template file should have an extension or a mimetype so that it can be automatically determined");
        }
        throw new NuxeoException("No template processor found for template type=" + templateType);
    }

    private Blob convertBlob(String templateName, Blob blob, String outputFormat) throws OperationException {
        OutputFormatDescriptor outFormat = this.getOutputFormatDescriptor(outputFormat);
        String chainId = outFormat.getChainId();
        String mimeType = outFormat.getMimeType();
        AutomationService automationService = (AutomationService)Framework.getService(AutomationService.class);
        try (OperationContext ctx = this.initOperationContext(blob, templateName);){
            Blob blob2;
            Object result = null;
            if (chainId != null) {
                ctx.put("templateSourceDocument", (Object)this.getSourceTemplateDoc(templateName));
                ctx.put("templateBasedDocument", (Object)this.adaptedDoc);
                result = automationService.run(ctx, chainId);
            } else if (mimeType != null) {
                OperationChain chain = new OperationChain("convertToMimeType");
                chain.add("Blob.Convert").set("mimeType", (Object)mimeType);
                result = automationService.run(ctx, chain);
            }
            if (result != null && result instanceof Blob) {
                blob2 = (Blob)result;
                return blob2;
            }
            blob2 = blob;
            return blob2;
        }
    }

    protected OperationContext initOperationContext(Blob blob, String templateName) {
        OperationContext ctx = new OperationContext();
        ctx.put("templateName", (Object)templateName);
        ctx.setInput((Object)blob);
        ctx.setCommit(false);
        ctx.setCoreSession(this.getSession());
        return ctx;
    }

    public Blob renderAndStoreAsAttachment(String templateName, boolean save) {
        Blob blob = this.renderWithTemplate(templateName);
        this.setBlob(blob);
        if (save) {
            this.adaptedDoc = this.getSession().saveDocument(this.adaptedDoc);
        }
        return blob;
    }

    public boolean isBidirectional() {
        return false;
    }

    public Blob getTemplateBlob(String templateName) {
        TemplateSourceDocument source = this.getSourceTemplate(templateName);
        if (source != null) {
            Blob blob;
            BlobHolder bh;
            if (source.useAsMainContent() && (bh = (BlobHolder)this.getAdaptedDoc().getAdapter(BlobHolder.class)) != null && (blob = bh.getBlob()) != null) {
                return blob;
            }
            Blob blob2 = source.getTemplateBlob();
            return blob2;
        }
        BlobHolder bh = (BlobHolder)this.getAdaptedDoc().getAdapter(BlobHolder.class);
        if (bh == null) {
            return null;
        }
        return bh.getBlob();
    }

    public boolean hasParams(String templateName) {
        return this.getParams(templateName).size() > 0;
    }

    public List<TemplateInput> getParams(String templateName) {
        TemplateBinding binding = this.bindings.get(templateName);
        if (binding != null) {
            String xml = binding.getData();
            try {
                return XMLSerializer.readFromXml(xml);
            }
            catch (DocumentException e) {
                log.error((Object)"Unable to parse parameters", (Throwable)e);
                return new ArrayList<TemplateInput>();
            }
        }
        return new ArrayList<TemplateInput>();
    }

    public DocumentModel saveParams(String templateName, List<TemplateInput> params, boolean save) {
        TemplateBinding binding = this.bindings.get(templateName);
        if (binding != null) {
            binding.setData(params);
            this.bindings.save(this.adaptedDoc);
        }
        if (save) {
            this.doSave();
        }
        return this.adaptedDoc;
    }

    protected TemplateProcessor getTemplateProcessor(String templateName) {
        TemplateProcessorService tps = (TemplateProcessorService)Framework.getService(TemplateProcessorService.class);
        return tps.getProcessor(this.getTemplateType(templateName));
    }

    protected OutputFormatDescriptor getOutputFormatDescriptor(String outputFormat) {
        TemplateProcessorService tps = (TemplateProcessorService)Framework.getService(TemplateProcessorService.class);
        return tps.getOutputFormatDescriptor(outputFormat);
    }

    public boolean hasEditableParams(String templateName) {
        for (TemplateInput param : this.getParams(templateName)) {
            if (param.isReadOnly()) continue;
            return true;
        }
        return false;
    }

    public String getTemplateNameForRendition(String renditionName) {
        for (TemplateBinding binding : this.bindings) {
            TemplateSourceDocument template = this.getSourceTemplate(binding.getName());
            if (template == null || !renditionName.equals(template.getTargetRenditionName())) continue;
            return binding.getName();
        }
        return null;
    }

    public List<String> getTemplateNames() {
        return this.bindings.getNames();
    }
}

