/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.adapters.doc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.template.adapters.doc.TemplateBinding;

public class TemplateBindings
extends ArrayList<TemplateBinding> {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_BINDING = "default";
    public static final String BINDING_PROP_NAME = "nxts:bindings";

    public TemplateBindings(DocumentModel doc) {
        Serializable value = doc.getPropertyValue(BINDING_PROP_NAME);
        if (value != null) {
            List bindings = (List)((Object)value);
            for (Map binding : bindings) {
                this.add(new TemplateBinding(binding));
            }
        }
    }

    public String useMainContentAsTemplate() {
        for (TemplateBinding tb : this) {
            if (!tb.isUseMainContentAsTemplate()) continue;
            return tb.getName();
        }
        return null;
    }

    public TemplateBinding get() {
        return this.get(DEFAULT_BINDING);
    }

    public void removeByName(String templateName) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            TemplateBinding binding = (TemplateBinding)it.next();
            if (!binding.getName().equals(templateName)) continue;
            it.remove();
            return;
        }
    }

    public boolean containsTemplateName(String templateName) {
        for (TemplateBinding tb : this) {
            if (!templateName.equals(tb.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsTemplateId(String templateId) {
        for (TemplateBinding tb : this) {
            if (!templateId.equals(tb.getTemplateId())) continue;
            return true;
        }
        return false;
    }

    public TemplateBinding get(String name) {
        for (TemplateBinding tb : this) {
            if (!name.equals(tb.getName())) continue;
            return tb;
        }
        return null;
    }

    public void addOrUpdate(TemplateBinding tb) {
        TemplateBinding existing = this.get(tb.getName());
        if (existing == null) {
            this.add(tb);
        } else {
            existing.update(tb);
        }
    }

    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (TemplateBinding tb : this) {
            names.add(tb.getName());
        }
        return names;
    }

    public void save(DocumentModel doc) {
        ArrayList<Map<String, Serializable>> bindings = new ArrayList<Map<String, Serializable>>();
        for (TemplateBinding tb : this) {
            bindings.add(tb.getAsMap());
        }
        doc.setPropertyValue(BINDING_PROP_NAME, (Serializable)bindings);
    }
}

