/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.jaxrs;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;
import org.nuxeo.template.jaxrs.TemplateResource;

@WebObject(type="templateBasedResource")
public class TemplateBasedResource
extends DefaultObject {
    protected String uuid;

    public TemplateBasedResource() {
        this.uuid = null;
    }

    public TemplateBasedResource(String uuid) {
        this.uuid = uuid;
    }

    protected void initialize(Object ... args) {
        if (args != null && args.length > 0) {
            this.uuid = (String)args[0];
        }
    }

    protected TemplateBasedDocument resolve() {
        if (this.uuid != null) {
            IdRef idRef = new IdRef(this.uuid);
            DocumentModel doc = this.getContext().getCoreSession().getDocument((DocumentRef)idRef);
            return (TemplateBasedDocument)doc.getAdapter(TemplateBasedDocument.class);
        }
        return null;
    }

    @GET
    public Object get() {
        TemplateBasedDocument tmpl = this.resolve();
        if (tmpl == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(tmpl.getAdaptedDoc().getId() + " - " + tmpl.getAdaptedDoc().getTitle());
        return sb.toString();
    }

    @GET
    @Path(value="templates")
    public String getAssociatedTemplates() {
        IdRef idRef = new IdRef(this.uuid);
        DocumentModel doc = this.getContext().getCoreSession().getDocument((DocumentRef)idRef);
        TemplateBasedDocument tmpl = (TemplateBasedDocument)doc.getAdapter(TemplateBasedDocument.class);
        if (tmpl == null) {
            return "This document is not template based";
        }
        return tmpl.getTemplateNames().toString();
    }

    @Path(value="template/{name}")
    public Object getAssociatedTemplate(@PathParam(value="name") String name) {
        IdRef idRef = new IdRef(this.uuid);
        DocumentModel doc = this.getContext().getCoreSession().getDocument((DocumentRef)idRef);
        TemplateBasedDocument tmpl = (TemplateBasedDocument)doc.getAdapter(TemplateBasedDocument.class);
        if (tmpl == null) {
            return "This document is not template based";
        }
        DocumentRef sourceRef = tmpl.getSourceTemplateDocRef(name);
        if (sourceRef != null) {
            return this.getContext().newObject("templateResource", new Object[]{sourceRef.toString()});
        }
        return null;
    }

    @GET
    @Path(value="resource/{templateName}/{resourceName}")
    @Produces(value={"*/*"})
    public Blob getResource(@PathParam(value="templateName") String templateName, @PathParam(value="resourceName") String resourceName) {
        TemplateSourceDocument template;
        TemplateBasedDocument tmpl = this.resolve();
        BlobHolder bh = (BlobHolder)tmpl.getAdaptedDoc().getAdapter(BlobHolder.class);
        if (bh != null) {
            for (Blob blob : bh.getBlobs()) {
                if (!resourceName.equalsIgnoreCase(blob.getFilename())) continue;
                return blob;
            }
        }
        if ((template = tmpl.getSourceTemplate(templateName)) != null) {
            return TemplateResource.getResource(template, resourceName);
        }
        return null;
    }
}

