/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.Main;

public final class JSUtils {
    private static final Log log = LogFactory.getLog(JSUtils.class);
    private static final Global global = Main.getGlobal();

    public static String compressSource(String source) {
        IProxy iproxy = new IProxy(source);
        return (String)Main.shellContextFactory.call((ContextAction)iproxy);
    }

    static {
        ToolErrorReporter errorReporter = new ToolErrorReporter(false, global.getErr());
        Main.shellContextFactory.setErrorReporter((ErrorReporter)errorReporter);
        global.init((ContextFactory)Main.shellContextFactory);
    }

    private static class IProxy
    implements ContextAction {
        private final String source;

        IProxy(String source) {
            this.source = source;
        }

        public Object run(Context cx) {
            try {
                Script script = Main.loadScriptFromSource((Context)cx, (String)this.source, (String)"compress", (int)1, null);
                return cx.compressReader((Scriptable)global, script, this.source, "compress", 1, null);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"Could not compress javascript source.");
                return this.source;
            }
            catch (NoSuchMethodError e) {
                log.info((Object)"Could not compress javascript source. custom_rhino.jar is probably not installed.");
                return this.source;
            }
        }
    }
}

