/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html.ui;

import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.html.CSSUtils;
import org.nuxeo.theme.themes.ThemeDescriptor;
import org.nuxeo.theme.themes.ThemeManager;

public class ThemeStyles {
    private static final Log log = LogFactory.getLog(ThemeStyles.class);
    private static final boolean IGNORE_VIEW_NAME = false;
    private static final boolean IGNORE_CLASSNAME = false;
    private static final boolean INDENT = false;

    public static String render(Map<String, String> params, boolean cache, boolean inline, boolean virtualHosting) {
        String themeName = params.get("themeName");
        String path = params.get("path");
        String basePath = params.get("basepath");
        String cssPath = VirtualHostHelper.getContextPathProperty() + "/nxthemes-css";
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptorByThemeName((String)themeName);
        if (themeDescriptor != null && !themeDescriptor.isLoaded()) {
            ThemeManager.loadTheme((ThemeDescriptor)themeDescriptor);
        }
        if (inline) {
            StringBuilder sb = new StringBuilder();
            ThemeManager themeManager = Manager.getThemeManager();
            for (Style style : themeManager.getNamedStyles(themeName)) {
                sb.append(CSSUtils.styleToCss(style, style.getSelectorViewNames(), false, false, false));
            }
            for (Style style : themeManager.getStyles(themeName)) {
                sb.append(CSSUtils.styleToCss(style, style.getSelectorViewNames(), false, false, false));
            }
            String rendered = sb.toString();
            rendered = CSSUtils.expandVariables(rendered, basePath, themeDescriptor);
            return String.format("<style type=\"text/css\">%s</style>", rendered);
        }
        long timestamp = 0L;
        if (cache) {
            if (themeDescriptor != null) {
                timestamp = themeDescriptor.getLastModified().getTime();
            }
        } else {
            timestamp = new Date().getTime();
        }
        return String.format("<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"%s/%s-styles.css?theme=%s&amp;path=%s&amp;basepath=%s&amp;timestamp=%s\" />", cssPath, themeName, themeName, path, basePath, timestamp);
    }
}

