/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.CachingDef;
import org.nuxeo.theme.html.WebLength;

public final class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static final String[] lengthUnits = new String[]{"%", "em", "px", "ex", "pt", "in", "cm", "mm", "pc"};

    private Utils() {
    }

    public static String toJson(Object object) {
        return JSONObject.fromObject((Object)object).toString();
    }

    public static String addWebLengths(String length1, String length2) {
        WebLength webLength1 = Utils.getWebLength(length1);
        WebLength webLength2 = Utils.getWebLength(length2);
        if (!webLength1.unit.equals(webLength2.unit)) {
            return null;
        }
        return new WebLength(webLength1.value + webLength2.value, webLength1.unit).toString();
    }

    public static String substractWebLengths(String length1, String length2) {
        WebLength webLength1 = Utils.getWebLength(length1);
        WebLength webLength2 = Utils.getWebLength(length2);
        if (!webLength1.unit.equals(webLength2.unit)) {
            return null;
        }
        return new WebLength(webLength1.value - webLength2.value, webLength1.unit).toString();
    }

    public static String divideWebLength(String length, int divider) {
        if (divider <= 0) {
            return null;
        }
        WebLength webLength = Utils.getWebLength(length);
        if (webLength != null) {
            return new WebLength(webLength.value / divider, webLength.unit).toString();
        }
        return null;
    }

    private static WebLength getWebLength(String length) {
        Integer value = null;
        String unit = null;
        for (String lengthUnit : lengthUnits) {
            if (!length.endsWith(lengthUnit)) continue;
            unit = lengthUnit;
            try {
                value = Integer.valueOf(length.substring(0, length.length() - lengthUnit.length()));
            }
            catch (NumberFormatException e) {
                log.error((Object)"Could not convert web lengths to integers", (Throwable)e);
            }
            break;
        }
        if (value != null && unit != null) {
            return new WebLength(value, unit);
        }
        return null;
    }

    public static boolean supportsGzip(HttpServletRequest request) {
        String encoding = request.getHeader("Accept-Encoding");
        return encoding != null && encoding.toLowerCase(Locale.ENGLISH).contains("gzip");
    }

    public static void setCacheHeaders(HttpServletResponse response, CachingDef caching) {
        String lifetime;
        if (caching != null && (lifetime = caching.getLifetime()) != null) {
            long now = System.currentTimeMillis();
            response.addHeader("Cache-Control", "max-age=" + lifetime);
            response.addHeader("Cache-Control", "must-revalidate");
            response.setDateHeader("Last-Modified", now);
            response.setDateHeader("Expires", now + new Long(lifetime) * 1000L);
        }
    }

    public static boolean isVirtualHosting(HttpServletRequest request) {
        return request.getHeader("X-Forwarded-Host") != null;
    }

    public static String getImageMimeType(String ext) {
        if ("png".equals(ext = ext.toLowerCase())) {
            return "image/png";
        }
        if ("gif".equals(ext)) {
            return "image/gif";
        }
        if ("jpg".equals(ext) || "jpeg".equals(ext) || "jpe".equals(ext)) {
            return "image/jpeg";
        }
        return "application/octet-stream";
    }
}

