/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.component;

import java.io.IOException;
import java.net.URL;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.resources.ResourceManager;

public class UIResources
extends UIOutput {
    public void encodeAll(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String resourcePath = "/nuxeo/nxthemes-lib/";
        URL themeUrl = (URL)context.getExternalContext().getRequestMap().get("nxthemesThemeUrl");
        String path = context.getExternalContext().getRequestContextPath();
        ResourceManager resourceManager = Manager.getResourceManager();
        StringBuilder combinedStyles = new StringBuilder();
        StringBuilder combinedScripts = new StringBuilder();
        combinedStyles.append("/nuxeo/nxthemes-lib/");
        combinedScripts.append("/nuxeo/nxthemes-lib/");
        boolean hasScripts = false;
        boolean hasStyles = false;
        for (String resourceName : resourceManager.getResourcesFor(themeUrl)) {
            if (resourceName.endsWith(".css")) {
                combinedStyles.append(resourceName).append(",");
                hasStyles = true;
                continue;
            }
            if (!resourceName.endsWith(".js")) continue;
            combinedScripts.append(resourceName).append(",");
            hasScripts = true;
        }
        combinedStyles.deleteCharAt(combinedStyles.length() - 1);
        combinedScripts.deleteCharAt(combinedScripts.length() - 1);
        combinedStyles.append("?path=").append(path);
        combinedScripts.append("?path=").append(path);
        if (hasStyles) {
            writer.startElement("link", (UIComponent)this);
            writer.writeAttribute("type", (Object)"text/css", null);
            writer.writeAttribute("rel", (Object)"stylesheet", null);
            writer.writeAttribute("media", (Object)"all", null);
            writer.writeAttribute("href", (Object)combinedStyles.toString(), null);
            writer.endElement("link");
        }
        if (hasScripts) {
            writer.startElement("script", (UIComponent)this);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeAttribute("src", (Object)combinedScripts.toString(), null);
            writer.endElement("script");
        }
    }
}

