/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.views;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.models.InfoPool;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.resources.ResourceManager;
import org.nuxeo.theme.views.AbstractView;
import org.nuxeo.theme.views.ViewType;

public class JSFView
extends AbstractView {
    private static final Log log = LogFactory.getLog(JSFView.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String render(RenderingInfo info) {
        String result;
        block27: {
            URL themeUrl = info.getThemeUrl();
            ViewType viewType = this.getViewType();
            String template = viewType.getTemplate();
            ResourceManager resourceManager = Manager.getResourceManager();
            InfoPool infoPool = Manager.getInfoPool();
            for (String resource : viewType.getResources()) {
                resourceManager.addResource(resource, themeUrl);
            }
            result = "";
            InputStream is = null;
            try {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(template);
                if (is == null) {
                    log.warn((Object)("View template not found: " + template));
                    break block27;
                }
                Reader in = null;
                try {
                    int ch;
                    in = new BufferedReader(new InputStreamReader(is));
                    StringBuilder rendered = new StringBuilder();
                    while ((ch = in.read()) > -1) {
                        rendered.append((char)ch);
                    }
                    result = rendered.toString();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        try {
                            is.close();
                            is = null;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            is = null;
                        }
                    }
                    catch (Throwable throwable) {
                        is = null;
                        throw throwable;
                    }
                }
            }
        }
        String infoId = InfoPool.computeInfoId((RenderingInfo)info);
        result = result.replaceAll("nxthemesInfo.", String.format("nxthemesInfo.map.%s.", infoId));
        return result.replace("[nxthemes markup]", info.getMarkup());
    }
}

