/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.servlets;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NegotiationSelector
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NegotiationSelector.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String perspective;
        String theme;
        String referer = request.getHeader("referer");
        if (referer == null) {
            log.error((Object)"No referer found.");
            response.sendRedirect("/nuxeo/nxthemes/error/negotiationSelectorMissingReferer.faces");
            return;
        }
        String root = request.getContextPath();
        String engine = request.getParameter("engine");
        if (engine != null) {
            response.addCookie(this.createCookie("nxthemes.engine", engine, root));
        }
        if ((theme = request.getParameter("theme")) != null) {
            response.addCookie(this.createCookie("nxthemes.theme", theme, root));
        }
        if ((perspective = request.getParameter("perspective")) != null) {
            response.addCookie(this.createCookie("nxthemes.perspective", perspective, root));
        }
        response.sendRedirect(referer);
    }

    private Cookie createCookie(String name, String value, String root) {
        Cookie cookie = new Cookie(name, value);
        if (value.equals("")) {
            cookie.setMaxAge(0);
        }
        cookie.setPath(root);
        return cookie;
    }
}

