/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class DiffContext {
    SimulationContext ref;
    SimulationContext challenger;
    List<String> scripts;
    long max;

    public DiffContext(List<SimulationContext> stats) {
        this.ref = stats.get(0);
        this.challenger = stats.get(1);
        this.max = Math.max(this.ref.simStat.max, this.challenger.simStat.max);
    }

    public DiffContext setScripts(List<String> scripts) {
        this.scripts = scripts;
        return this;
    }

    public List<DiffRequestStat> getDiffRequests() {
        ArrayList<DiffRequestStat> ret = new ArrayList<DiffRequestStat>(this.ref.reqStats.size());
        for (RequestStat refStat : this.ref.getRequests()) {
            RequestStat challengerStat = this.challenger.reqStats.get(refStat.request);
            if (challengerStat == null) {
                challengerStat = new RequestStat(refStat.simulation, refStat.scenario, refStat.request, 0L, null);
                challengerStat.add(0L, 0L, false);
                challengerStat.computeStat(0);
            }
            ret.add(new DiffRequestStat(refStat, challengerStat));
        }
        Collections.reverse(ret);
        return ret;
    }

    public String avgPercent() {
        return String.format(Locale.ENGLISH, "%+.2f", this.challenger.simStat.avg * 100.0 / this.ref.simStat.avg - 100.0);
    }

    public String avgClass() {
        if (this.challenger.simStat.avg < this.ref.simStat.avg) {
            return "win";
        }
        return "loose";
    }

    public String rpsPercent() {
        return String.format(Locale.ENGLISH, "%+.2f", this.challenger.simStat.rps * 100.0 / this.ref.simStat.rps - 100.0);
    }

    public String rpsClass() {
        if (this.challenger.simStat.rps > this.ref.simStat.rps) {
            return "win";
        }
        return "loose";
    }
}

