/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Graphite {
    private static final Logger log = Logger.getLogger(Report.class);
    final ZoneId zoneId;
    String dashboardUrl;
    String user;
    String password;
    String baseUrl;
    List<Image> images = new ArrayList<Image>();
    String from;
    String until;
    File outputDirectory;

    public Graphite(String graphiteUrl, String user, String password, SimulationContext stats, File outputDirectory, ZoneId zoneId) {
        this.dashboardUrl = graphiteUrl;
        this.baseUrl = Utils.getBaseUrl(graphiteUrl);
        this.zoneId = zoneId == null ? ZoneId.systemDefault() : zoneId;
        this.from = this.getDateAsString(stats.simStat.start - 30000L);
        this.until = this.getDateAsString(stats.simStat.end + 60000L);
        this.outputDirectory = outputDirectory;
        this.user = user;
        this.password = password;
        Utils.setBasicAuth(user, password);
        this.parseDashboard();
        this.downloadImages();
    }

    private String getDateAsString(long start) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm_yyyyMMdd").withZone(this.zoneId);
        return formatter.format(Instant.ofEpochMilli(start));
    }

    private void downloadImages() {
        this.images.forEach(image -> {
            block2: {
                try {
                    this.downloadImage((Image)image);
                }
                catch (IOException e) {
                    log.warn((Object)("Fail to download image: " + image.title));
                    if (!log.isDebugEnabled()) break block2;
                    log.debug((Object)"Download error", (Throwable)e);
                }
            }
        });
    }

    private void downloadImage(Image image) throws IOException {
        File dest = image.getFile(this.outputDirectory);
        Utils.download(new URL(image.url), dest);
    }

    private void parseDashboard() {
        Object obj;
        JSONParser parser = new JSONParser();
        try {
            obj = parser.parse(this.getJsonDashboard());
        }
        catch (IOException | ParseException e) {
            log.error((Object)("Failed to parse Graphite dashboard: " + this.dashboardUrl), e);
            throw new IllegalArgumentException("invalid dashboard link " + this.dashboardUrl, e);
        }
        JSONObject jsonObject = (JSONObject)obj;
        JSONArray graphs = (JSONArray)((JSONObject)jsonObject.get((Object)"state")).get((Object)"graphs");
        for (Object graph : graphs) {
            String title = ((JSONObject)((JSONArray)graph).get(1)).get((Object)"title").toString();
            String graphUrl = (String)((JSONArray)graph).get(2);
            this.images.add(new Image(this.baseUrl + graphUrl, title, this.from, this.until));
        }
    }

    private String getJsonDashboard() throws IOException {
        String url = this.getJsonDashboardUrl();
        log.info((Object)("Downloading: " + url));
        return Utils.getContent(new URL(url));
    }

    private String getJsonDashboardUrl() {
        return String.format("%s?from=%s&until=%s", this.dashboardUrl.replace("/dashboard/#", "/dashboard/load/"), this.from, this.until);
    }

    class Image {
        String url;
        String title;
        String filename;

        public Image(String url, String title, String from, String until) {
            this.url = this.getUrl(url, from, until);
            this.title = title;
        }

        private String getUrl(String url, String from, String until) {
            return url + String.format("&from=%s&until=%s", from, until);
        }

        public File getFile(File outputDirectory) {
            this.filename = (this.title + "_" + Graphite.this.from).replaceAll("\\W+", "") + ".png";
            return new File(outputDirectory, this.filename);
        }
    }
}

