/*
 * Decompiled with CFR 0.152.
 */
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;

public class RequestStat {
    private static final long MAX_BOXPOINT = 50000L;
    String simulation;
    String scenario;
    String request;
    String requestId;
    static AtomicInteger statCounter = new AtomicInteger();
    int indice;
    String startDate;
    long start;
    long end;
    long count;
    long successCount;
    long errorCount;
    long min;
    long max;
    long stddev;
    long p50;
    long p95;
    long p99;
    double rps;
    double avg;
    double duration;
    List<Double> durations;
    Graphite graphite;
    Apdex apdex;
    int maxUsers;

    public RequestStat(String simulation, String scenario, String request, long start, Float apdexT) {
        this.simulation = simulation;
        this.scenario = scenario;
        this.request = request;
        this.requestId = Utils.getIdentifier(request);
        this.start = start;
        this.durations = new ArrayList<Double>();
        this.indice = statCounter.incrementAndGet();
        this.apdex = new Apdex(apdexT);
    }

    public void add(long start, long end, boolean success) {
        ++this.count;
        if (this.start == 0L) {
            this.start = start;
        }
        this.start = Math.min(this.start, start);
        this.end = Math.max(this.end, end);
        if (!success) {
            ++this.errorCount;
        }
        long duration = end - start;
        this.durations.add(Double.valueOf(duration));
        this.apdex.addMs(duration);
    }

    public void computeStat(int maxUsers) {
        this.computeStat((double)(this.end - this.start) / 1000.0, maxUsers);
    }

    public void computeStat(double duration, int maxUsers) {
        double[] times = this.getDurationAsArray();
        this.min = (long)StatUtils.min((double[])times);
        this.max = (long)StatUtils.max((double[])times);
        double sum = 0.0;
        for (double d : times) {
            sum += d;
        }
        this.avg = sum / (double)times.length;
        this.p50 = (long)StatUtils.percentile((double[])times, (double)50.0);
        this.p95 = (long)StatUtils.percentile((double[])times, (double)95.0);
        this.p99 = (long)StatUtils.percentile((double[])times, (double)99.0);
        StandardDeviation stdDev = new StandardDeviation();
        this.stddev = (long)stdDev.evaluate(times, this.avg);
        this.duration = duration;
        this.maxUsers = maxUsers;
        this.rps = (double)(this.count - this.errorCount) / duration;
        this.startDate = this.getDateFromInstant(this.start);
        this.successCount = this.count - this.errorCount;
    }

    public void setSimulationName(String name) {
        this.simulation = name;
    }

    public void setScenario(String name) {
        this.scenario = name;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public String average() {
        return String.format(Locale.ENGLISH, "%.1f", this.avg);
    }

    public String boxpoints() {
        if (this.count < 50000L) {
            return "'all'";
        }
        return "false";
    }

    public String throughput() {
        return String.format(Locale.ENGLISH, "%.1f", this.rps);
    }

    public String percentError() {
        if (this.count == 0L) {
            return "0.00";
        }
        return String.format(Locale.ENGLISH, "%.2f", (double)this.errorCount * 100.0 / (double)this.count);
    }

    private String getDateFromInstant(long start) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
        return formatter.format(Instant.ofEpochMilli(start));
    }

    private double[] getDurationAsArray() {
        double[] ret = new double[this.durations.size()];
        for (int i = 0; i < this.durations.size(); ++i) {
            ret[i] = this.durations.get(i);
        }
        return ret;
    }

    public String getDuration() {
        return String.format(Locale.ENGLISH, "%.1f", this.duration);
    }

    public static String header() {
        return "simulation\tscenario\tmaxUsers\trequest\tstart\tstartDate\tduration\tend\tcount\tsuccessCount\terrorCount\tmin\tp50\tp95\tp99\tmax\tavg\tstddev\trps\tapdex\trating";
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "%s\t%s\t%s\t%s\t%s\t%s\t%.2f\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%.2f\t%s\t%.2f\t%.2f\t%s", new Object[]{this.simulation, this.scenario, this.maxUsers, this.request, this.start, this.startDate, this.duration, this.end, this.count, this.successCount, this.errorCount, this.min, this.p50, this.p95, this.p99, this.max, this.avg, this.stddev, this.rps, Float.valueOf(this.apdex.getScore()), this.apdex.getRating()});
    }
}

