/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SimulationContext {
    String filePath;
    String simulationName;
    RequestStat simStat;
    Map<String, RequestStat> reqStats = new HashMap<String, RequestStat>();
    List<String> scripts = new ArrayList<String>();
    int maxUsers;
    private final Float apdexT;
    private static final String ALL_REQUESTS = "_all";
    private long start;
    Map<String, CountMax> users = new HashMap<String, CountMax>();

    public SimulationContext(String filePath, Float apdexT) {
        this.filePath = filePath;
        this.simStat = new RequestStat(ALL_REQUESTS, ALL_REQUESTS, ALL_REQUESTS, 0L, apdexT);
        this.apdexT = apdexT;
    }

    public List<RequestStat> getRequests() {
        ArrayList<RequestStat> ret = new ArrayList<RequestStat>(this.reqStats.values());
        Collections.sort(ret, (a, b) -> (int)(1000.0 * (a.avg - b.avg)));
        return ret;
    }

    public void addRequest(String scenario, String requestName, long start, long end, boolean success) {
        RequestStat request = this.reqStats.get(requestName);
        if (request == null) {
            request = new RequestStat(this.simulationName, scenario, requestName, this.start, this.apdexT);
            this.reqStats.put(requestName, request);
        }
        request.add(start, end, success);
        this.simStat.add(start, end, success);
    }

    public void computeStat() {
        this.maxUsers = this.users.values().stream().mapToInt(CountMax::getMax).sum();
        this.simStat.computeStat(this.maxUsers);
        this.reqStats.values().forEach(request -> request.computeStat(this.simStat.duration, this.users.get((Object)request.scenario).maximum));
    }

    public void setSimulationName(String name) {
        this.simulationName = name;
        this.simStat.setSimulationName(name);
    }

    public void setStart(long start) {
        this.start = start;
        this.simStat.setStart(start);
    }

    public SimulationContext setScripts(List<String> scripts) {
        this.scripts = scripts;
        return this;
    }

    public String toString() {
        return this.simStat.toString() + "\n" + this.getRequests().stream().map(RequestStat::toString).collect(Collectors.joining("\n"));
    }

    public SimulationContext setMaxUsers(int maxUsers) {
        this.maxUsers = maxUsers;
        return this;
    }

    public void addUser(String scenario) {
        CountMax count = this.users.get(scenario);
        if (count == null) {
            count = new CountMax();
            this.users.put(scenario, count);
        }
        count.incr();
    }

    public void endUser(String scenario) {
        CountMax count = this.users.get(scenario);
        if (count != null) {
            count.decr();
        }
    }

    class CountMax {
        int current = 0;
        int maximum = 0;

        CountMax() {
        }

        public void incr() {
            ++this.current;
            this.maximum = Math.max(this.current, this.maximum);
        }

        public void decr() {
            --this.current;
        }

        public int getMax() {
            return this.maximum;
        }
    }
}

