/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class TrendContext {
    String scenario;
    TrendStat all = new TrendStat();
    List<TrendStat> requests = new ArrayList<TrendStat>();
    List<String> scripts;

    public TrendContext(List<SimulationContext> stats) {
        HashSet<String> names = new HashSet<String>();
        List<String> requestNames = this.getRequestListSorted(stats.get(0));
        Collections.reverse(requestNames);
        for (String requestName : requestNames) {
            this.requests.add(new TrendStat());
        }
        ArrayList<SimulationContext> orderedStats = new ArrayList<SimulationContext>(stats);
        Collections.sort(orderedStats, (a, b) -> (int)(a.simStat.start - b.simStat.start));
        for (SimulationContext simStat : orderedStats) {
            names.add(simStat.simulationName);
            this.all.add(simStat.simStat);
            for (int i = 0; i < requestNames.size(); ++i) {
                String name = requestNames.get(i);
                RequestStat reqStat = simStat.reqStats.get(name);
                this.requests.get(i).add(reqStat);
            }
        }
        this.scenario = String.join((CharSequence)" ", names);
    }

    public TrendContext setScripts(List<String> scripts) {
        this.scripts = scripts;
        return this;
    }

    private List<String> getRequestListSorted(SimulationContext stat) {
        return stat.getRequests().stream().map(s -> s.request).collect(Collectors.toList());
    }

    public TrendStat getRef() {
        return this.requests.get(0);
    }

    public TrendStat getChallenger() {
        return this.requests.get(1);
    }

    class TrendStat {
        String name;
        Integer indice;
        List<String> xvalues = new ArrayList<String>();
        List<Double> yvalues = new ArrayList<Double>();
        List<Long> yerrors = new ArrayList<Long>();
        List<Double> rps = new ArrayList<Double>();

        TrendStat() {
        }

        public void add(RequestStat stat) {
            if (stat == null) {
                this.xvalues.add(null);
                this.yvalues.add(null);
                this.yerrors.add(null);
                this.rps.add(null);
            } else {
                this.name = stat.request;
                this.indice = stat.indice;
                this.xvalues.add(String.format("'%s'", stat.startDate));
                this.yvalues.add(stat.avg);
                this.yerrors.add(stat.stddev);
                this.rps.add(stat.rps);
            }
        }
    }
}

