/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;

public class Utils {
    static void setBasicAuth(final String user, final String password) {
        if (user == null) {
            return;
        }
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, password.toCharArray());
            }
        });
    }

    static String getBaseUrl(String url) {
        URL targetUrl;
        try {
            targetUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + url, e);
        }
        return targetUrl.getProtocol() + "://" + targetUrl.getHost();
    }

    static void download(URL src, File dest) throws IOException {
        URLConnection conn = src.openConnection();
        byte[] buffer = new byte[8192];
        try (InputStream input = conn.getInputStream();
             FileOutputStream output = new FileOutputStream(dest);){
            int bytesRead;
            while ((bytesRead = input.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, bytesRead);
            }
        }
    }

    static String getContent(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        StringBuilder ret = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                ret.append(line);
            }
        }
        return ret.toString();
    }

    static String getIdentifier(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isLetter(str.charAt(i))) continue;
            sb.append(str.charAt(i));
        }
        return sb.toString().toLowerCase();
    }
}

