/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.maven;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.nuxeo.maven.bundle.BundleWalker;
import org.nuxeo.maven.bundle.ContributionsHolder;
import org.nuxeo.maven.bundle.FakeRuntimeService;
import org.nuxeo.maven.publisher.Publisher;
import org.nuxeo.maven.runtime.MojoRuntime;
import org.nuxeo.maven.serializer.StudioSerializer;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;

@Mojo(name="extract", requiresProject=false, defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE, inheritByDefault=false, aggregator=true, threadSafe=true)
public class ExtractorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, property="nsmp.project")
    protected MavenProject project;
    @Parameter(defaultValue="*", property="nsmp.extract")
    protected String extract;
    @Parameter(defaultValue="nuxeo-studio-registries.json", property="nsmp.output")
    protected String output;
    @Parameter(property="nsmp.token")
    protected String token;
    @Parameter(property="nsmp.symbolicName")
    protected String symbolicName;
    @Parameter(defaultValue="https://connect.nuxeo.com/nuxeo", property="nsmp.connectUrl")
    protected String connectUrl;
    protected StudioSerializer serializer;
    protected ContributionsHolder holder;

    protected void initialize() throws MojoExecutionException, IOException {
        this.holder = new ContributionsHolder();
        this.serializer = new StudioSerializer(this, this.holder);
        if (!ExtractorMojo.isStandalone(this.project)) {
            MojoRuntime.initCustomClassLoader(this.project);
        }
    }

    public String getBuildDirectory() {
        return ExtractorMojo.isStandalone(this.project) ? Paths.get("", new String[0]).toAbsolutePath().toString() : this.project.getBuild().getDirectory();
    }

    protected static String getBuildOutputDirectory(MavenProject project) {
        return ExtractorMojo.isStandalone(project) ? Paths.get("", new String[0]).toAbsolutePath().toString() : project.getBuild().getOutputDirectory();
    }

    protected static boolean isStandalone(MavenProject project) {
        return project.getId().startsWith("org.apache.maven:standalone-pom:");
    }

    protected List<MavenProject> getProjects() {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        projects.add(this.project);
        if (!ExtractorMojo.isStandalone(this.project)) {
            projects.addAll(this.project.getCollectedProjects());
        }
        return projects;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.initialize();
            this.getProjects().forEach(this::loadContributions);
            String[] targets = "*".equals(this.extract) ? this.holder.getManager().getRegisteredTargets() : this.extract.split(",|\\s\\s*");
            Publisher.instance(this).publish(targets);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to publish extractions", (Exception)e);
        }
    }

    protected void loadContributions(MavenProject project) {
        BundleWalker walker = new BundleWalker(ExtractorMojo.getBuildOutputDirectory(project));
        try {
            walker.getRegistrationInfos().forEach(this.holder::load);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public String getExtract() {
        return this.extract;
    }

    public String getOutput() {
        return this.output;
    }

    public String getToken() {
        return this.token;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getConnectUrl() {
        return this.connectUrl;
    }

    public StudioSerializer getSerializer() {
        return this.serializer;
    }

    public ContributionsHolder getHolder() {
        return this.holder;
    }

    static {
        try {
            System.setProperty("nuxeo.home", Files.createTempDirectory("nuxeo", new FileAttribute[0]).toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Framework.initialize((RuntimeService)new FakeRuntimeService());
    }
}

