/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.maven.bundle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.nuxeo.maven.runtime.MojoRuntime;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.ComponentDescriptorReader;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;

public class BundleWalker {
    private Path basePath;
    private Log log;
    private ComponentDescriptorReader reader = new ComponentDescriptorReader();

    public BundleWalker() {
    }

    public BundleWalker(String basePath) {
        this(new File(basePath));
    }

    public BundleWalker(File basePath) {
        this();
        this.setBasePath(basePath);
    }

    private Path findFile(String filePath) {
        try {
            return Files.walk(this.basePath, new FileVisitOption[0]).filter(s -> s.endsWith(filePath)).findFirst().orElse(null);
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
            this.getLog().warn((CharSequence)(filePath + ":" + e.getMessage()));
            return null;
        }
    }

    public Stream<Path> getComponents() throws IOException {
        Manifest manifest;
        Path manifestPath = this.getManifest();
        if (manifestPath == null) {
            this.getLog().info((CharSequence)String.format("%s do no contains MANIFEST.MF file", this.basePath.toAbsolutePath().toString()));
            return Stream.empty();
        }
        try (FileInputStream fis = new FileInputStream(manifestPath.toFile());){
            manifest = new Manifest(fis);
        }
        String components = manifest.getMainAttributes().getValue("Nuxeo-Component");
        if (StringUtils.isBlank((CharSequence)components)) {
            return Stream.empty();
        }
        return Arrays.stream(components.split("[, \t\n\r\f]")).filter(StringUtils::isNotBlank).map(this::findFile).filter(Objects::nonNull);
    }

    public Path getManifest() {
        return this.findFile("META-INF/MANIFEST.MF");
    }

    private Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public Stream<RegistrationInfo> getRegistrationInfos() throws IOException {
        return this.getComponents().map(this::read).filter(Objects::nonNull);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RegistrationInfo read(Path component) {
        try (FileInputStream is = new FileInputStream(component.toFile());){
            RegistrationInfoImpl registrationInfoImpl = this.reader.read((RuntimeContext)MojoRuntime.instance, (InputStream)is);
            return registrationInfoImpl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setBasePath(File basePath) {
        this.basePath = basePath != null ? basePath.toPath() : null;
    }
}

