/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.maven.bundle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.maven.mapper.MappersManager;
import org.nuxeo.maven.mapper.impl.AutomationMapper;
import org.nuxeo.maven.mapper.impl.EventMapper;
import org.nuxeo.maven.mapper.impl.LifeCycleMapper;
import org.nuxeo.maven.mapper.impl.PermissionsMapper;
import org.nuxeo.maven.mapper.impl.TypeServiceMapper;
import org.nuxeo.runtime.model.RegistrationInfo;

public class ContributionsHolder {
    protected final Map<String, List<Object>> contributions = new HashMap<String, List<Object>>();
    protected final MappersManager manager;

    public ContributionsHolder() {
        this(MappersManager.instance().add(new TypeServiceMapper()).add(new PermissionsMapper()).add(new AutomationMapper()).add(new LifeCycleMapper()).add(new EventMapper()));
    }

    public ContributionsHolder(MappersManager manager) {
        this.manager = manager;
    }

    public MappersManager getManager() {
        return this.manager;
    }

    public void load(RegistrationInfo ri) {
        Arrays.stream(ri.getExtensions()).map(this.manager::load).forEach(a -> Arrays.stream(a).forEach(c -> {
            List sortedContributions = this.contributions.computeIfAbsent(c.getClass().getName(), s -> new ArrayList());
            sortedContributions.add(c);
        }));
    }

    public <T> List<T> getContributions(Class<T> descriptor) {
        ArrayList list = new ArrayList();
        for (Object contribution : this.contributions.getOrDefault(descriptor.getName(), Collections.emptyList())) {
            if (!this.manager.isSerializable(descriptor, contribution)) continue;
            list.add(contribution);
        }
        return list;
    }
}

