/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.maven.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.XMapContext;

public abstract class ExtensionMapper {
    protected Map<String, List<Class<?>>> descriptors = new HashMap();

    public ExtensionMapper() {
        this.registerDescriptors();
    }

    public abstract void registerDescriptors();

    protected abstract boolean accept(String var1, String var2);

    public void registerDescriptor(String name, Class<?> descriptor) {
        this.descriptors.computeIfAbsent(name, s -> new ArrayList()).add(descriptor);
    }

    public boolean accept(Extension ext) {
        return this.accept(ext.getTargetComponent().getName(), ext.getExtensionPoint());
    }

    public boolean isEnabled(Object contribution) {
        return true;
    }

    public boolean isPartial(Object contribution) {
        return false;
    }

    public Object[] loadAll(RuntimeContext ctx, Extension extension) {
        XMap xmap = new XMap();
        this.getDescriptors().forEach(arg_0 -> ((XMap)xmap).register(arg_0));
        return xmap.loadAll((Context)new XMapContext(ctx), extension.getElement());
    }

    public List<Class<?>> getDescriptors() {
        return this.descriptors.values().stream().collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
    }

    public List<Class<?>> getDescriptor(String name) {
        return this.descriptors.getOrDefault(name, null);
    }

    public Set<String> getDescriptorNames() {
        return this.descriptors.keySet();
    }

    public boolean contains(Class<?> descriptor) {
        return this.descriptors.values().stream().anyMatch(list -> list.contains(descriptor));
    }
}

