/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.maven.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.nuxeo.maven.mapper.ExtensionMapper;
import org.nuxeo.maven.runtime.MojoRuntime;
import org.nuxeo.runtime.model.Extension;

public class MappersManager {
    private List<ExtensionMapper> mappers = new ArrayList<ExtensionMapper>();

    public static MappersManager instance() {
        return new MappersManager();
    }

    public MappersManager add(ExtensionMapper transformer) {
        this.mappers.add(transformer);
        return this;
    }

    public boolean accept(Extension ext) {
        return this.mappers.stream().anyMatch(s -> s.accept(ext));
    }

    public boolean isSerializable(Class<?> descriptor, Object contribution) {
        ExtensionMapper mapper = this.mappers.stream().filter(s -> s.contains(descriptor)).findFirst().orElseThrow(RuntimeException::new);
        return mapper.isEnabled(contribution) && !mapper.isPartial(contribution);
    }

    public List<Class<?>> getDescriptor(String name) {
        return this.mappers.stream().map(m -> m.getDescriptor(name)).filter(Objects::nonNull).findFirst().orElse(new ArrayList());
    }

    public String getDescriptorName(Class<?> klass) {
        return this.mappers.stream().map(s -> s.descriptors).map(Map::entrySet).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll).stream().filter(s -> ((List)s.getValue()).contains(klass)).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    public Object[] load(Extension ext) {
        ExtensionMapper mapper = this.mappers.stream().filter(s -> s.accept(ext)).findFirst().orElse(null);
        if (mapper != null) {
            return mapper.loadAll(MojoRuntime.instance, ext);
        }
        return new Object[0];
    }

    public String[] getRegisteredTargets() {
        return this.mappers.stream().map(ExtensionMapper::getDescriptorNames).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll).toArray(new String[0]);
    }
}

