/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.maven.publisher;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.maven.ExtractorMojo;
import org.nuxeo.maven.serializer.StudioSerializer;

public abstract class Publisher {
    protected StudioSerializer serializer;

    protected Publisher(StudioSerializer serializer) {
        this.serializer = serializer;
    }

    public static Publisher instance(ExtractorMojo mojo) {
        Publisher publisher = null;
        if (StringUtils.isNotBlank((CharSequence)mojo.getToken()) && StringUtils.isNotBlank((CharSequence)mojo.getSymbolicName())) {
            publisher = new StudioPublisher(mojo.getSerializer(), mojo.getConnectUrl(), mojo.getSymbolicName(), mojo.getToken());
        }
        if (publisher == null) {
            publisher = new FilePublisher(mojo.getSerializer(), new File(mojo.getBuildDirectory(), mojo.getOutput()));
        }
        return publisher;
    }

    public abstract void publish(String[] var1) throws IOException;

    public static class StudioPublisher
    extends Publisher {
        protected static final String TOKEN_HEADER = "X-Authentication-Token";
        protected static final String REGISTRY_ENDPOINT = "site/studio/v2/project/{symbolicName}/workspace/ws.registries";
        protected String connectUrl;
        protected String symbolicName;
        protected String token;

        public StudioPublisher(StudioSerializer serializer, String connectUrl, String symbolicName, String token) {
            super(serializer);
            this.connectUrl = connectUrl;
            this.symbolicName = symbolicName;
            this.token = token;
        }

        @Override
        public void publish(String[] targets) throws IOException {
            URI operationsUrl = UriBuilder.fromUri((String)this.connectUrl).path(REGISTRY_ENDPOINT).build(new Object[]{this.symbolicName});
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                this.serializer.serializeInto(baos, targets);
                Client client = Client.create();
                ClientResponse post = (ClientResponse)((WebResource.Builder)client.resource(operationsUrl).type(MediaType.APPLICATION_JSON_TYPE).header(TOKEN_HEADER, (Object)this.token)).post(ClientResponse.class, (Object)baos.toString("UTF-8"));
                if (post.getStatus() != Response.Status.CREATED.getStatusCode()) {
                    throw new IOException((String)post.getEntity(String.class));
                }
            }
        }
    }

    public static class FilePublisher
    extends Publisher {
        protected File output;

        public FilePublisher(StudioSerializer serializer, File output) {
            super(serializer);
            this.output = output;
        }

        @Override
        public void publish(String[] targets) throws IOException {
            try (PrintStream printStream = new PrintStream(this.output);){
                this.serializer.serializeInto(printStream, targets);
            }
        }

        public File getOutput() {
            return this.output;
        }
    }
}

