/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.maven.runtime;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.nuxeo.ecm.core.schema.SchemaManagerImpl;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.StreamRef;
import org.osgi.framework.Bundle;

public class MojoRuntime
implements RuntimeContext {
    public static MojoRuntime instance = new MojoRuntime();
    public static SchemaManagerImpl schemaManager = new SchemaManagerImpl();
    private static ClassLoader custom;

    private MojoRuntime() {
    }

    public static void initCustomClassLoader(MavenProject project) throws MojoExecutionException {
        try {
            HashSet compileClasspathElements = new HashSet();
            compileClasspathElements.addAll(project.getCompileClasspathElements());
            for (MavenProject child : project.getCollectedProjects()) {
                compileClasspathElements.addAll(child.getCompileClasspathElements());
            }
            ArrayList<URL> urlElements = new ArrayList<URL>();
            for (String s : compileClasspathElements) {
                urlElements.add(new File(s).toURI().toURL());
            }
            custom = new URLClassLoader(urlElements.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
        }
        catch (MalformedURLException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Unable to load compile dependencies", (Exception)e);
        }
    }

    protected ClassLoader getClassloader() {
        if (custom != null) {
            return custom;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public Class<?> loadClass(String s) throws ClassNotFoundException {
        return this.getClassloader().loadClass(s);
    }

    public RuntimeService getRuntime() {
        throw new UnsupportedOperationException();
    }

    public Bundle getBundle() {
        throw new UnsupportedOperationException();
    }

    public URL getResource(String name) {
        return this.getLocalResource(name);
    }

    public URL getLocalResource(String name) {
        URL loadedResource = this.getClassloader().getResource(name);
        if (loadedResource == null) {
            try {
                loadedResource = new File(name).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return loadedResource;
    }

    public RegistrationInfo deploy(URL url) throws IOException {
        throw new UnsupportedOperationException();
    }

    public RegistrationInfo deploy(StreamRef streamRef) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(URL url) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(StreamRef streamRef) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isDeployed(URL url) {
        throw new UnsupportedOperationException();
    }

    public boolean isDeployed(StreamRef streamRef) {
        throw new UnsupportedOperationException();
    }

    public RegistrationInfo deploy(String s) {
        throw new UnsupportedOperationException();
    }

    public void undeploy(String s) {
        throw new UnsupportedOperationException();
    }

    public boolean isDeployed(String s) {
        throw new UnsupportedOperationException();
    }

    public void destroy() {
    }
}

