/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.maven.serializer;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.core.OperationChainContribution;
import org.nuxeo.ecm.automation.core.OperationContribution;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.lifecycle.extensions.LifeCycleDescriptor;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.FacetDescriptor;
import org.nuxeo.ecm.core.schema.SchemaBindingDescriptor;
import org.nuxeo.ecm.core.schema.types.SchemaImpl;
import org.nuxeo.ecm.core.security.PermissionDescriptor;
import org.nuxeo.maven.ExtractorMojo;
import org.nuxeo.maven.serializer.adapter.DefaultAdapter;
import org.nuxeo.maven.serializer.adapter.OperationAdapter;
import org.nuxeo.maven.serializer.adapter.OperationChainAdapter;
import org.nuxeo.maven.serializer.adapter.SchemaAdapter;
import org.nuxeo.maven.serializer.adapter.SerializerAdapter;
import org.nuxeo.maven.serializer.mixin.DocTypeMixin;
import org.nuxeo.maven.serializer.mixin.EventListenerMixin;
import org.nuxeo.maven.serializer.mixin.FacetMixin;
import org.nuxeo.maven.serializer.mixin.LifeCycleMixin;
import org.nuxeo.maven.serializer.mixin.OperationDocumentationMixin;
import org.nuxeo.maven.serializer.mixin.PermissionMixin;
import org.nuxeo.maven.serializer.mixin.SchemaMixin;

public class JacksonConverter {
    protected Map<Class<?>, Class<?>> mixins = new HashMap();
    protected Map<Class<?>, SerializerAdapter> adapters = new HashMap();
    protected SerializerAdapter defaultAdapter = new DefaultAdapter();
    protected ExtractorMojo mojo;

    public static JacksonConverter instance(ExtractorMojo mojo) {
        return new JacksonConverter(mojo);
    }

    private JacksonConverter(ExtractorMojo mojo) {
        this.mojo = mojo;
        this.registerAdapter(OperationContribution.class, OperationAdapter.class);
        this.registerAdapter(SchemaBindingDescriptor.class, SchemaAdapter.class);
        this.registerAdapter(OperationChainContribution.class, OperationChainAdapter.class);
        this.registerMixin(FacetDescriptor.class, FacetMixin.class);
        this.registerMixin(PermissionDescriptor.class, PermissionMixin.class);
        this.registerMixin(OperationDocumentation.class, OperationDocumentationMixin.class);
        this.registerMixin(LifeCycleDescriptor.class, LifeCycleMixin.class);
        this.registerMixin(EventListenerDescriptor.class, EventListenerMixin.class);
        this.registerMixin(SchemaImpl.class, SchemaMixin.class);
        this.registerMixin(DocumentTypeDescriptor.class, DocTypeMixin.class);
    }

    protected void registerMixin(Class<?> target, Class<?> mixin) {
        this.mixins.put(target, mixin);
    }

    protected void registerAdapter(Class<?> target, Class<? extends SerializerAdapter> serializer) {
        try {
            this.adapters.put(target, serializer.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public String serialize(Object target) {
        try {
            ObjectMapper om = new ObjectMapper();
            Object targetAdapted = this.adapters.getOrDefault(target.getClass(), this.defaultAdapter).adapt(target);
            if (targetAdapted == null) {
                this.mojo.getLog().warn((CharSequence)("Unable to adapt: \"" + target + "\" (" + target.getClass() + ")"));
                return null;
            }
            om.addMixIn(targetAdapted.getClass(), this.mixins.getOrDefault(targetAdapted.getClass(), Object.class));
            return om.writeValueAsString(targetAdapted);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void newGlobalStudioObject(OutputStream os, Map<String, String> serialized) {
        JsonFactory factory = new JsonFactory();
        try (JsonGenerator gen = factory.createGenerator(os, JsonEncoding.UTF8);){
            gen.writeStartObject();
            for (String k : serialized.keySet()) {
                String value = serialized.get(k);
                if (StringUtils.isBlank((String)value)) continue;
                gen.writeFieldName(k);
                gen.writeRawValue(value);
            }
            gen.writeEndObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static abstract class StudioJacksonSerializer<T>
    extends StdSerializer<T> {
        public StudioJacksonSerializer() {
            this(null);
        }

        protected StudioJacksonSerializer(Class<T> t) {
            super(t);
        }
    }
}

