/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.maven.serializer;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.nuxeo.maven.ExtractorMojo;
import org.nuxeo.maven.bundle.ContributionsHolder;
import org.nuxeo.maven.serializer.JacksonConverter;

public class StudioSerializer {
    private static final List<String> asArray = Arrays.asList("facets", "operations");
    private ContributionsHolder holder;
    private ExtractorMojo mojo;

    public StudioSerializer(ContributionsHolder holder) {
        this(null, holder);
    }

    public StudioSerializer(ExtractorMojo mojo, ContributionsHolder holder) {
        this.holder = holder;
        this.mojo = mojo;
    }

    public void serializeInto(OutputStream os, String[] targets) {
        HashMap<String, String> serialized = new HashMap<String, String>();
        Arrays.stream(targets).forEach(t -> serialized.put((String)t, this.serializeDescriptors((String)t)));
        JacksonConverter.instance(this.mojo).newGlobalStudioObject(os, serialized);
    }

    public String serializeDescriptors(String name) {
        return this.serializeDescriptors(name, this.holder.getManager().getDescriptor(name));
    }

    public String serializeDescriptors(Class<?> descriptor) {
        String descriptorName = this.holder.getManager().getDescriptorName(descriptor);
        return this.serializeDescriptors(descriptorName, Collections.singletonList(descriptor));
    }

    public String serializeDescriptors(String name, List<Class<?>> descriptor) {
        String delimiter = this.getDelimiter();
        String prefix = this.getPrefix(name);
        String suffix = this.getSuffix(name);
        List contribs = descriptor.stream().map(this.holder::getContributions).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
        if (contribs.size() == 0) {
            return null;
        }
        return contribs.stream().map(this::serialize).filter(Objects::nonNull).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    protected String serialize(Object obj) {
        return JacksonConverter.instance(this.mojo).serialize(obj);
    }

    public String getDelimiter() {
        return ",";
    }

    public String getPrefix(String name) {
        return asArray.contains(name) ? "[" : "{";
    }

    public String getSuffix(String name) {
        return asArray.contains(name) ? "]" : "}";
    }
}

