/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.maven.serializer.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.OperationChainContribution;
import org.nuxeo.ecm.automation.core.impl.ChainTypeImpl;
import org.nuxeo.maven.serializer.adapter.SerializerAdapter;

public class OperationChainAdapter
implements SerializerAdapter<OperationChainContribution, OperationDocumentation> {
    @Override
    public OperationDocumentation adapt(OperationChainContribution src) {
        try {
            CustomChainTypeImpl impl = new CustomChainTypeImpl(src.toOperationChain(null), src);
            return impl.getDocumentation();
        }
        catch (OperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static class CustomChainTypeImpl
    extends ChainTypeImpl {
        private static final List<String> DEFAULT_SIGNATURE = new ArrayList<String>();

        public CustomChainTypeImpl(OperationChain chain, OperationChainContribution contribution) {
            super(null, chain, contribution);
        }

        protected ArrayList<String> getSignature(OperationChainContribution.Operation[] operations) throws OperationException {
            return new ArrayList<String>(DEFAULT_SIGNATURE);
        }

        static {
            List<String> possibleValues = Arrays.asList("documents", "document", "blob", "bloblist", "void");
            possibleValues.forEach(inputType -> possibleValues.forEach(outputType -> {
                DEFAULT_SIGNATURE.add((String)inputType);
                DEFAULT_SIGNATURE.add((String)outputType);
            }));
        }
    }
}

