/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.maven.serializer.adapter;

import org.nuxeo.ecm.core.schema.SchemaBindingDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManagerImpl;
import org.nuxeo.ecm.core.schema.XSDLoader;
import org.nuxeo.ecm.core.schema.types.SchemaImpl;
import org.nuxeo.ecm.core.schema.types.TypeException;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolverService;
import org.nuxeo.maven.runtime.MojoRuntime;
import org.nuxeo.maven.serializer.adapter.SerializerAdapter;
import org.xml.sax.SAXException;

public class SchemaAdapter
implements SerializerAdapter<SchemaBindingDescriptor, SchemaImpl> {
    @Override
    public SchemaImpl adapt(SchemaBindingDescriptor descriptor) {
        return SchemaAdapter.loadSchema(descriptor);
    }

    protected static SchemaImpl loadSchema(SchemaBindingDescriptor descriptor) {
        try {
            return new CustomXSDLoader(MojoRuntime.schemaManager, descriptor).loadSchema();
        }
        catch (TypeException | SAXException e) {
            throw new RuntimeException("Unable to adapt schema binding: " + descriptor.name, e);
        }
    }

    public static class CustomXSDLoader
    extends XSDLoader {
        public CustomXSDLoader(SchemaManagerImpl schemaManager, SchemaBindingDescriptor sd) {
            super(schemaManager, sd);
            sd.context = MojoRuntime.instance;
        }

        protected ObjectResolverService getObjectResolverService() {
            return (s, map) -> null;
        }

        public SchemaImpl loadSchema() throws TypeException, SAXException {
            return (SchemaImpl)this.loadSchema(this.sd.name, this.sd.prefix, MojoRuntime.instance.getLocalResource(this.sd.src));
        }
    }
}

