/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.maven.serializer.mixin;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.maven.serializer.JacksonConverter;

@JsonSerialize(using=DocTypeSerializer.class)
public abstract class DocTypeMixin {

    public static class DocTypeSerializer
    extends JacksonConverter.StudioJacksonSerializer<DocumentTypeDescriptor> {
        public void serialize(DocumentTypeDescriptor value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)value.superTypeName)) {
                obj.put("parent", value.superTypeName);
            }
            obj.put("schemas", Arrays.stream(value.schemas).map(s -> s.name).collect(Collectors.toList()));
            obj.put("facets", value.facets);
            gen.writeFieldName(value.name);
            gen.writeRawValue(":");
            gen.writeObject(obj);
        }
    }
}

