/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.maven.serializer.mixin;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.nuxeo.ecm.core.api.LifeCycleConstants;
import org.nuxeo.ecm.core.api.event.DocumentEventTypes;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.maven.serializer.JacksonConverter;
import org.nuxeo.maven.serializer.SerializerHelper;

@JsonSerialize(using=EventSerializer.class)
public abstract class EventListenerMixin {

    public static class EventSerializer
    extends JacksonConverter.StudioJacksonSerializer<EventListenerDescriptor> {
        private static List<String> systemEvents = EventSerializer.extractField(DocumentEventTypes.class);

        private static List<String> extractField(Class<?> type) {
            return FieldUtils.getAllFieldsList(type).stream().filter(s -> Modifier.isStatic(s.getModifiers())).map(s -> {
                try {
                    return s.get(null).toString();
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }).collect(Collectors.toList());
        }

        public void serialize(EventListenerDescriptor value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            String events = value.getEvents().stream().filter(e -> !systemEvents.contains(e)).map(e -> String.format("\"%s\":\"%s\"", e, SerializerHelper.humanize(e))).collect(Collectors.joining(","));
            gen.writeRaw(events);
        }

        static {
            systemEvents.addAll(EventSerializer.extractField(LifeCycleConstants.class));
        }
    }
}

