/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.maven.serializer.mixin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.PrimitiveType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.maven.serializer.JacksonConverter;

@JsonSerialize(using=SchemaSerializer.class)
public abstract class SchemaMixin {
    @JsonIgnore
    public Schema schema;

    public static class SchemaSerializer
    extends JacksonConverter.StudioJacksonSerializer<Schema> {
        public void serialize(Schema value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeFieldName(value.getName());
            gen.writeRaw(":");
            gen.writeStartObject();
            String prefix = value.getNamespace().prefix;
            if (StringUtils.isNotBlank((CharSequence)prefix)) {
                gen.writeStringField("@prefix", prefix);
            }
            for (Field field : value.getFields()) {
                this.writeField(gen, field);
            }
            gen.writeEndObject();
        }

        protected void writeSchemaObject(Schema schema, JsonGenerator jg) throws IOException {
            jg.writeStringField("name", schema.getName());
            String prefix = schema.getNamespace().prefix;
            if (StringUtils.isNotBlank((CharSequence)prefix)) {
                jg.writeStringField("prefix", prefix);
                jg.writeStringField("@prefix", prefix);
            }
            jg.writeObjectFieldStart("fields");
            for (Field field : schema.getFields()) {
                this.writeField(jg, field);
            }
            jg.writeEndObject();
        }

        protected void writeField(JsonGenerator jg, Field field) throws IOException {
            if (!field.getType().isComplexType()) {
                if (field.getType().isListType()) {
                    ListType lt = (ListType)field.getType();
                    if (lt.getFieldType().isComplexType()) {
                        if (lt.getFieldType().getName().equals("content")) {
                            jg.writeStringField(field.getName().getLocalName(), "blob[]");
                        } else {
                            jg.writeObjectFieldStart(field.getName().getLocalName());
                            jg.writeStringField("type", "complex[]");
                            jg.writeObjectFieldStart("fields");
                            ComplexType cplXType = (ComplexType)lt.getField().getType();
                            for (Field subField : cplXType.getFields()) {
                                this.writeField(jg, subField);
                            }
                            jg.writeEndObject();
                            jg.writeEndObject();
                        }
                    } else {
                        this.doWriteField(jg, field);
                    }
                } else {
                    this.doWriteField(jg, field);
                }
            } else if (field.getType().getName().equals("content")) {
                jg.writeStringField(field.getName().getLocalName(), "blob");
            } else {
                jg.writeObjectFieldStart(field.getName().getLocalName());
                ComplexType cplXType = (ComplexType)field.getType();
                jg.writeObjectFieldStart("fields");
                for (Field subField : cplXType.getFields()) {
                    this.writeField(jg, subField);
                }
                jg.writeEndObject();
                jg.writeStringField("type", "complex");
                jg.writeEndObject();
            }
        }

        protected void doWriteField(JsonGenerator jg, Field field) throws IOException {
            String typeValue;
            if (field.getType().isListType()) {
                ListType lt = (ListType)field.getType();
                Type type = lt.getFieldType();
                while (!(type instanceof PrimitiveType)) {
                    type = type.getSuperType();
                }
                typeValue = type.getName() + "[]";
            } else {
                Type type = field.getType();
                while (!(type instanceof PrimitiveType)) {
                    type = type.getSuperType();
                }
                typeValue = type.getName();
            }
            jg.writeStringField(field.getName().getLocalName(), typeValue);
        }
    }
}

