/*
 * Decompiled with CFR 0.152.
 */
package org.obsidiantoaster.generator;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.jboss.forge.service.producer.FurnaceProducer;

@WebListener
public class ForgeInitializer
implements ServletContextListener {
    private static final transient Logger LOG = Logger.getLogger(ForgeInitializer.class.getName());
    private static String version;
    @Inject
    FurnaceProducer furnaceProducer;
    private static Path rootPath;

    public void contextInitialized(ServletContextEvent sce) {
        try {
            ServletContext servletContext = sce.getServletContext();
            version = servletContext.getInitParameter("project.version");
            File repoDir = new File(servletContext.getResource("/WEB-INF/addons").toURI());
            LOG.info("initializing furnace with folder: " + repoDir.getAbsolutePath());
            File[] files = repoDir.listFiles();
            if (files == null || files.length == 0) {
                LOG.warning("No files found in the addon directory: " + repoDir.getAbsolutePath());
            } else {
                LOG.warning("Found " + files.length + " addon files in directory: " + repoDir.getAbsolutePath());
            }
            this.furnaceProducer.setup(repoDir);
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOG.log(Level.SEVERE, "Error while setting up Furnace", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    public static Path getRoot() {
        if (rootPath == null && !Files.exists(rootPath = Paths.get(System.getenv().getOrDefault("OPENSHIFT_TMP_DIR", "/tmp"), "workspace"), new LinkOption[0])) {
            try {
                Files.createDirectory(rootPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rootPath;
    }

    public static String getVersion() {
        return version;
    }
}

