/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.spi;

import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.DigesterPrettyConfigParser;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.PrettyConfigBuilder;
import com.ocpsoft.pretty.faces.spi.ConfigurationProvider;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;

public class DefaultXMLConfigurationProvider
implements ConfigurationProvider {
    private static final Log log = LogFactory.getLog(DefaultXMLConfigurationProvider.class);
    public static final String DEFAULT_PRETTY_FACES_CONFIG = "/WEB-INF/pretty-config.xml";

    @Override
    public PrettyConfig loadConfiguration(ServletContext servletContext) {
        PrettyConfigBuilder builder = new PrettyConfigBuilder();
        DigesterPrettyConfigParser configParser = new DigesterPrettyConfigParser();
        InputStream is = servletContext.getResourceAsStream(DEFAULT_PRETTY_FACES_CONFIG);
        if (is != null) {
            log.trace("Reading config [/WEB-INF/pretty-config.xml].");
            try {
                configParser.parse(builder, is);
            }
            catch (Exception e) {
                throw new PrettyException("Failed to parse PrettyFaces configuration from /WEB-INF/pretty-config.xml", e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return builder.build();
    }
}

