/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.chart;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartAutomaticContentAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartDisplayEquationAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartDisplayRSquareAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.svg.SvgXAttribute;
import org.odftoolkit.odfdom.dom.attribute.svg.SvgYAttribute;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element chart:equation}. */
public class ChartEquationElement extends OdfElement {

  public static final OdfName ELEMENT_NAME =
      OdfName.newName(OdfDocumentNamespace.CHART, "equation");

  /**
   * Create the instance of <code>ChartEquationElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public ChartEquationElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element chart:equation}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>ChartAutomaticContentAttribute
   * </code> , See {@odf.attribute chart:automatic-content}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getChartAutomaticContentAttribute() {
    ChartAutomaticContentAttribute attr =
        (ChartAutomaticContentAttribute)
            getOdfAttribute(OdfDocumentNamespace.CHART, "automatic-content");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(ChartAutomaticContentAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>ChartAutomaticContentAttribute</code> ,
   * See {@odf.attribute chart:automatic-content}
   *
   * @param chartAutomaticContentValue The type is <code>Boolean</code>
   */
  public void setChartAutomaticContentAttribute(Boolean chartAutomaticContentValue) {
    ChartAutomaticContentAttribute attr =
        new ChartAutomaticContentAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(chartAutomaticContentValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>ChartDisplayEquationAttribute
   * </code> , See {@odf.attribute chart:display-equation}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getChartDisplayEquationAttribute() {
    ChartDisplayEquationAttribute attr =
        (ChartDisplayEquationAttribute)
            getOdfAttribute(OdfDocumentNamespace.CHART, "display-equation");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(ChartDisplayEquationAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>ChartDisplayEquationAttribute</code> ,
   * See {@odf.attribute chart:display-equation}
   *
   * @param chartDisplayEquationValue The type is <code>Boolean</code>
   */
  public void setChartDisplayEquationAttribute(Boolean chartDisplayEquationValue) {
    ChartDisplayEquationAttribute attr =
        new ChartDisplayEquationAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(chartDisplayEquationValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>ChartDisplayRSquareAttribute
   * </code> , See {@odf.attribute chart:display-r-square}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getChartDisplayRSquareAttribute() {
    ChartDisplayRSquareAttribute attr =
        (ChartDisplayRSquareAttribute)
            getOdfAttribute(OdfDocumentNamespace.CHART, "display-r-square");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(ChartDisplayRSquareAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>ChartDisplayRSquareAttribute</code> ,
   * See {@odf.attribute chart:display-r-square}
   *
   * @param chartDisplayRSquareValue The type is <code>Boolean</code>
   */
  public void setChartDisplayRSquareAttribute(Boolean chartDisplayRSquareValue) {
    ChartDisplayRSquareAttribute attr =
        new ChartDisplayRSquareAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(chartDisplayRSquareValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>ChartStyleNameAttribute</code>
   * , See {@odf.attribute chart:style-name}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getChartStyleNameAttribute() {
    ChartStyleNameAttribute attr =
        (ChartStyleNameAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "style-name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>ChartStyleNameAttribute</code> , See
   * {@odf.attribute chart:style-name}
   *
   * @param chartStyleNameValue The type is <code>String</code>
   */
  public void setChartStyleNameAttribute(String chartStyleNameValue) {
    ChartStyleNameAttribute attr = new ChartStyleNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(chartStyleNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>SvgXAttribute</code> , See
   * {@odf.attribute svg:x}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getSvgXAttribute() {
    SvgXAttribute attr = (SvgXAttribute) getOdfAttribute(OdfDocumentNamespace.SVG, "x");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>SvgXAttribute</code> , See
   * {@odf.attribute svg:x}
   *
   * @param svgXValue The type is <code>String</code>
   */
  public void setSvgXAttribute(String svgXValue) {
    SvgXAttribute attr = new SvgXAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(svgXValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>SvgYAttribute</code> , See
   * {@odf.attribute svg:y}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getSvgYAttribute() {
    SvgYAttribute attr = (SvgYAttribute) getOdfAttribute(OdfDocumentNamespace.SVG, "y");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>SvgYAttribute</code> , See
   * {@odf.attribute svg:y}
   *
   * @param svgYValue The type is <code>String</code>
   */
  public void setSvgYAttribute(String svgYValue) {
    SvgYAttribute attr = new SvgYAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(svgYValue);
  }

  /**
   * Create child element {@odf.element text:p}.
   *
   * <p>Child element was added in ODF 1.2
   *
   * @return the element {@odf.element text:p}
   */
  public TextPElement newTextPElement() {
    TextPElement textP = ((OdfFileDom) this.ownerDocument).newOdfElement(TextPElement.class);
    this.appendChild(textP);
    return textP;
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }
}
