/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.db.DbDecimalAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbFieldAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbStringAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbThousandAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element db:delimiter}. */
public class DbDelimiterElement extends OdfElement {

  public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.DB, "delimiter");

  /**
   * Create the instance of <code>DbDelimiterElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public DbDelimiterElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element db:delimiter}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbDecimalAttribute</code> , See
   * {@odf.attribute db:decimal}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbDecimalAttribute() {
    DbDecimalAttribute attr =
        (DbDecimalAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "decimal");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DbDecimalAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbDecimalAttribute</code> , See
   * {@odf.attribute db:decimal}
   *
   * @param dbDecimalValue The type is <code>String</code>
   */
  public void setDbDecimalAttribute(String dbDecimalValue) {
    DbDecimalAttribute attr = new DbDecimalAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbDecimalValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbFieldAttribute</code> , See
   * {@odf.attribute db:field}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbFieldAttribute() {
    DbFieldAttribute attr = (DbFieldAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "field");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DbFieldAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbFieldAttribute</code> , See
   * {@odf.attribute db:field}
   *
   * @param dbFieldValue The type is <code>String</code>
   */
  public void setDbFieldAttribute(String dbFieldValue) {
    DbFieldAttribute attr = new DbFieldAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbFieldValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbStringAttribute</code> , See
   * {@odf.attribute db:string}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbStringAttribute() {
    DbStringAttribute attr = (DbStringAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "string");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DbStringAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbStringAttribute</code> , See
   * {@odf.attribute db:string}
   *
   * @param dbStringValue The type is <code>String</code>
   */
  public void setDbStringAttribute(String dbStringValue) {
    DbStringAttribute attr = new DbStringAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbStringValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbThousandAttribute</code> ,
   * See {@odf.attribute db:thousand}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbThousandAttribute() {
    DbThousandAttribute attr =
        (DbThousandAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "thousand");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DbThousandAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbThousandAttribute</code> , See
   * {@odf.attribute db:thousand}
   *
   * @param dbThousandValue The type is <code>String</code>
   */
  public void setDbThousandAttribute(String dbThousandValue) {
    DbThousandAttribute attr = new DbThousandAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbThousandValue);
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }
}
