/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.db.DbDescriptionAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbTitleAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element db:query-collection}. */
public class DbQueryCollectionElement extends OdfElement {

  public static final OdfName ELEMENT_NAME =
      OdfName.newName(OdfDocumentNamespace.DB, "query-collection");

  /**
   * Create the instance of <code>DbQueryCollectionElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public DbQueryCollectionElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element db:query-collection}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbDescriptionAttribute</code> ,
   * See {@odf.attribute db:description}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbDescriptionAttribute() {
    DbDescriptionAttribute attr =
        (DbDescriptionAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "description");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbDescriptionAttribute</code> , See
   * {@odf.attribute db:description}
   *
   * @param dbDescriptionValue The type is <code>String</code>
   */
  public void setDbDescriptionAttribute(String dbDescriptionValue) {
    DbDescriptionAttribute attr = new DbDescriptionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbDescriptionValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbNameAttribute</code> , See
   * {@odf.attribute db:name}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbNameAttribute() {
    DbNameAttribute attr = (DbNameAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbNameAttribute</code> , See
   * {@odf.attribute db:name}
   *
   * @param dbNameValue The type is <code>String</code>
   */
  public void setDbNameAttribute(String dbNameValue) {
    DbNameAttribute attr = new DbNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbTitleAttribute</code> , See
   * {@odf.attribute db:title}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbTitleAttribute() {
    DbTitleAttribute attr = (DbTitleAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "title");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbTitleAttribute</code> , See
   * {@odf.attribute db:title}
   *
   * @param dbTitleValue The type is <code>String</code>
   */
  public void setDbTitleAttribute(String dbTitleValue) {
    DbTitleAttribute attr = new DbTitleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbTitleValue);
  }

  /**
   * Create child element {@odf.element db:query}.
   *
   * @param dbCommandValue the <code>String</code> value of <code>DbCommandAttribute</code>, see
   *     {@odf.attribute db:command} at specification
   * @param dbNameValue the <code>String</code> value of <code>DbNameAttribute</code>, see
   *     {@odf.attribute db:name} at specification Child element was added in ODF 1.2
   * @return the element {@odf.element db:query}
   */
  public DbQueryElement newDbQueryElement(String dbCommandValue, String dbNameValue) {
    DbQueryElement dbQuery = ((OdfFileDom) this.ownerDocument).newOdfElement(DbQueryElement.class);
    dbQuery.setDbCommandAttribute(dbCommandValue);
    dbQuery.setDbNameAttribute(dbNameValue);
    this.appendChild(dbQuery);
    return dbQuery;
  }

  /**
   * Create child element {@odf.element db:query-collection}.
   *
   * @param dbNameValue the <code>String</code> value of <code>DbNameAttribute</code>, see
   *     {@odf.attribute db:name} at specification Child element was added in ODF 1.2
   * @return the element {@odf.element db:query-collection}
   */
  public DbQueryCollectionElement newDbQueryCollectionElement(String dbNameValue) {
    DbQueryCollectionElement dbQueryCollection =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DbQueryCollectionElement.class);
    dbQueryCollection.setDbNameAttribute(dbNameValue);
    this.appendChild(dbQueryCollection);
    return dbQueryCollection;
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }
}
