/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.number;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.number.NumberFormatSourceAttribute;
import org.odftoolkit.odfdom.dom.attribute.number.NumberTruncateOnOverflowAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element number:time-style}. */
public abstract class NumberTimeStyleElement extends NumberDataStyleElementBase {

  public static final OdfName ELEMENT_NAME =
      OdfName.newName(OdfDocumentNamespace.NUMBER, "time-style");

  /**
   * Create the instance of <code>NumberTimeStyleElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public NumberTimeStyleElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element number:time-style}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>NumberFormatSourceAttribute
   * </code> , See {@odf.attribute number:format-source}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getNumberFormatSourceAttribute() {
    NumberFormatSourceAttribute attr =
        (NumberFormatSourceAttribute) getOdfAttribute(OdfDocumentNamespace.NUMBER, "format-source");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return NumberFormatSourceAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>NumberFormatSourceAttribute</code> ,
   * See {@odf.attribute number:format-source}
   *
   * @param numberFormatSourceValue The type is <code>String</code>
   */
  public void setNumberFormatSourceAttribute(String numberFormatSourceValue) {
    NumberFormatSourceAttribute attr =
        new NumberFormatSourceAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(numberFormatSourceValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * NumberTruncateOnOverflowAttribute</code> , See {@odf.attribute number:truncate-on-overflow}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getNumberTruncateOnOverflowAttribute() {
    NumberTruncateOnOverflowAttribute attr =
        (NumberTruncateOnOverflowAttribute)
            getOdfAttribute(OdfDocumentNamespace.NUMBER, "truncate-on-overflow");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(NumberTruncateOnOverflowAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>NumberTruncateOnOverflowAttribute
   * </code> , See {@odf.attribute number:truncate-on-overflow}
   *
   * @param numberTruncateOnOverflowValue The type is <code>Boolean</code>
   */
  public void setNumberTruncateOnOverflowAttribute(Boolean numberTruncateOnOverflowValue) {
    NumberTruncateOnOverflowAttribute attr =
        new NumberTruncateOnOverflowAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(numberTruncateOnOverflowValue.booleanValue());
  }

  /**
   * Create child element {@odf.element number:am-pm}.
   *
   * @return the element {@odf.element number:am-pm}
   */
  public NumberAmPmElement newNumberAmPmElement() {
    NumberAmPmElement numberAmPm =
        ((OdfFileDom) this.ownerDocument).newOdfElement(NumberAmPmElement.class);
    this.appendChild(numberAmPm);
    return numberAmPm;
  }

  /**
   * Create child element {@odf.element number:hours}.
   *
   * @return the element {@odf.element number:hours}
   */
  public NumberHoursElement newNumberHoursElement() {
    NumberHoursElement numberHours =
        ((OdfFileDom) this.ownerDocument).newOdfElement(NumberHoursElement.class);
    this.appendChild(numberHours);
    return numberHours;
  }

  /**
   * Create child element {@odf.element number:minutes}.
   *
   * @return the element {@odf.element number:minutes}
   */
  public NumberMinutesElement newNumberMinutesElement() {
    NumberMinutesElement numberMinutes =
        ((OdfFileDom) this.ownerDocument).newOdfElement(NumberMinutesElement.class);
    this.appendChild(numberMinutes);
    return numberMinutes;
  }

  /**
   * Create child element {@odf.element number:seconds}.
   *
   * @return the element {@odf.element number:seconds}
   */
  public NumberSecondsElement newNumberSecondsElement() {
    NumberSecondsElement numberSeconds =
        ((OdfFileDom) this.ownerDocument).newOdfElement(NumberSecondsElement.class);
    this.appendChild(numberSeconds);
    return numberSeconds;
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }
}
