/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBackgroundColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoCountryAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoFontFamilyAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoFontSizeAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoFontStyleAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoFontVariantAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoFontWeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoHyphenateAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoHyphenationPushCharCountAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoHyphenationRemainCharCountAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoLanguageAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoLetterSpacingAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoScriptAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoTextShadowAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoTextTransformAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleCountryAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleCountryComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontCharsetAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontCharsetAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontCharsetComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontFamilyAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontFamilyComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontFamilyGenericAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontFamilyGenericAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontFamilyGenericComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontNameAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontNameComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontPitchAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontPitchAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontPitchComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontReliefAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontSizeAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontSizeComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontSizeRelAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontSizeRelAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontSizeRelComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontStyleAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontStyleComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontStyleNameAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontStyleNameComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontWeightAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontWeightComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLanguageAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLanguageComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLetterKerningAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRfcLanguageTagAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRfcLanguageTagAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRfcLanguageTagComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleScriptAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleScriptComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleScriptTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextBlinkingAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextCombineAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextCombineEndCharAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextCombineStartCharAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextEmphasizeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextLineThroughColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextLineThroughModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextLineThroughStyleAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextLineThroughTextAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextLineThroughTextStyleAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextLineThroughTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextLineThroughWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextOutlineAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextOverlineColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextOverlineModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextOverlineStyleAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextOverlineTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextOverlineWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextPositionAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextRotationAngleAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextRotationScaleAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextScaleAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextUnderlineColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextUnderlineModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextUnderlineStyleAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextUnderlineTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextUnderlineWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleUseWindowFontColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextConditionAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextDisplayAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element style:text-properties}. */
public class StyleTextPropertiesElement extends OdfStylePropertiesBase {

  public static final OdfName ELEMENT_NAME =
      OdfName.newName(OdfDocumentNamespace.STYLE, "text-properties");

  /**
   * Create the instance of <code>StyleTextPropertiesElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public StyleTextPropertiesElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element style:text-properties}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  public static final OdfStyleProperty BackgroundColor =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "background-color"));

  public static final OdfStyleProperty Color =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties, OdfName.newName(OdfDocumentNamespace.FO, "color"));

  public static final OdfStyleProperty Country =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "country"));

  public static final OdfStyleProperty FontFamily =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "font-family"));

  public static final OdfStyleProperty FontSize =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "font-size"));

  public static final OdfStyleProperty FontStyle =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "font-style"));

  public static final OdfStyleProperty FontVariant =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "font-variant"));

  public static final OdfStyleProperty FontWeight =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "font-weight"));

  public static final OdfStyleProperty Hyphenate =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "hyphenate"));

  public static final OdfStyleProperty HyphenationPushCharCount =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "hyphenation-push-char-count"));

  public static final OdfStyleProperty HyphenationRemainCharCount =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "hyphenation-remain-char-count"));

  public static final OdfStyleProperty Language =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "language"));

  public static final OdfStyleProperty LetterSpacing =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "letter-spacing"));

  public static final OdfStyleProperty Script =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties, OdfName.newName(OdfDocumentNamespace.FO, "script"));

  public static final OdfStyleProperty TextShadow =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "text-shadow"));

  public static final OdfStyleProperty TextTransform =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "text-transform"));

  public static final OdfStyleProperty CountryAsian =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "country-asian"));

  public static final OdfStyleProperty CountryComplex =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "country-complex"));

  public static final OdfStyleProperty FontCharset =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-charset"));

  public static final OdfStyleProperty FontCharsetAsian =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-charset-asian"));

  public static final OdfStyleProperty FontCharsetComplex =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-charset-complex"));

  public static final OdfStyleProperty FontFamilyAsian =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-family-asian"));

  public static final OdfStyleProperty FontFamilyComplex =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-family-complex"));

  public static final OdfStyleProperty FontFamilyGeneric =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-family-generic"));

  public static final OdfStyleProperty FontFamilyGenericAsian =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-family-generic-asian"));

  public static final OdfStyleProperty FontFamilyGenericComplex =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-family-generic-complex"));

  public static final OdfStyleProperty FontName =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-name"));

  public static final OdfStyleProperty FontNameAsian =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-name-asian"));

  public static final OdfStyleProperty FontNameComplex =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-name-complex"));

  public static final OdfStyleProperty FontPitch =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-pitch"));

  public static final OdfStyleProperty FontPitchAsian =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-pitch-asian"));

  public static final OdfStyleProperty FontPitchComplex =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-pitch-complex"));

  public static final OdfStyleProperty FontRelief =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-relief"));

  public static final OdfStyleProperty FontSizeAsian =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-size-asian"));

  public static final OdfStyleProperty FontSizeComplex =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-size-complex"));

  public static final OdfStyleProperty FontSizeRel =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-size-rel"));

  public static final OdfStyleProperty FontSizeRelAsian =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-size-rel-asian"));

  public static final OdfStyleProperty FontSizeRelComplex =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-size-rel-complex"));

  public static final OdfStyleProperty FontStyleAsian =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-style-asian"));

  public static final OdfStyleProperty FontStyleComplex =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-style-complex"));

  public static final OdfStyleProperty FontStyleName =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-style-name"));

  public static final OdfStyleProperty FontStyleNameAsian =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-style-name-asian"));

  public static final OdfStyleProperty FontStyleNameComplex =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-style-name-complex"));

  public static final OdfStyleProperty FontWeightAsian =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-weight-asian"));

  public static final OdfStyleProperty FontWeightComplex =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-weight-complex"));

  public static final OdfStyleProperty LanguageAsian =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "language-asian"));

  public static final OdfStyleProperty LanguageComplex =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "language-complex"));

  public static final OdfStyleProperty LetterKerning =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "letter-kerning"));

  public static final OdfStyleProperty RfcLanguageTag =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "rfc-language-tag"));

  public static final OdfStyleProperty RfcLanguageTagAsian =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "rfc-language-tag-asian"));

  public static final OdfStyleProperty RfcLanguageTagComplex =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "rfc-language-tag-complex"));

  public static final OdfStyleProperty ScriptAsian =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "script-asian"));

  public static final OdfStyleProperty ScriptComplex =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "script-complex"));

  public static final OdfStyleProperty ScriptType =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "script-type"));

  public static final OdfStyleProperty TextBlinking =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-blinking"));

  public static final OdfStyleProperty TextCombine =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-combine"));

  public static final OdfStyleProperty TextCombineEndChar =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-combine-end-char"));

  public static final OdfStyleProperty TextCombineStartChar =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-combine-start-char"));

  public static final OdfStyleProperty TextEmphasize =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-emphasize"));

  public static final OdfStyleProperty TextLineThroughColor =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-line-through-color"));

  public static final OdfStyleProperty TextLineThroughMode =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-line-through-mode"));

  public static final OdfStyleProperty TextLineThroughStyle =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-line-through-style"));

  public static final OdfStyleProperty TextLineThroughText =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-line-through-text"));

  public static final OdfStyleProperty TextLineThroughTextStyle =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-line-through-text-style"));

  public static final OdfStyleProperty TextLineThroughType =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-line-through-type"));

  public static final OdfStyleProperty TextLineThroughWidth =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-line-through-width"));

  public static final OdfStyleProperty TextOutline =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-outline"));

  public static final OdfStyleProperty TextOverlineColor =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-overline-color"));

  public static final OdfStyleProperty TextOverlineMode =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-overline-mode"));

  public static final OdfStyleProperty TextOverlineStyle =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-overline-style"));

  public static final OdfStyleProperty TextOverlineType =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-overline-type"));

  public static final OdfStyleProperty TextOverlineWidth =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-overline-width"));

  public static final OdfStyleProperty TextPosition =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-position"));

  public static final OdfStyleProperty TextRotationAngle =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-rotation-angle"));

  public static final OdfStyleProperty TextRotationScale =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-rotation-scale"));

  public static final OdfStyleProperty TextScale =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-scale"));

  public static final OdfStyleProperty TextUnderlineColor =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-underline-color"));

  public static final OdfStyleProperty TextUnderlineMode =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-underline-mode"));

  public static final OdfStyleProperty TextUnderlineStyle =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-underline-style"));

  public static final OdfStyleProperty TextUnderlineType =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-underline-type"));

  public static final OdfStyleProperty TextUnderlineWidth =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-underline-width"));

  public static final OdfStyleProperty UseWindowFontColor =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "use-window-font-color"));

  public static final OdfStyleProperty Condition =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.TEXT, "condition"));

  public static final OdfStyleProperty Display =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TextProperties,
          OdfName.newName(OdfDocumentNamespace.TEXT, "display"));

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoBackgroundColorAttribute
   * </code> , See {@odf.attribute fo:background-color}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoBackgroundColorAttribute() {
    FoBackgroundColorAttribute attr =
        (FoBackgroundColorAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "background-color");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoBackgroundColorAttribute</code> , See
   * {@odf.attribute fo:background-color}
   *
   * @param foBackgroundColorValue The type is <code>String</code>
   */
  public void setFoBackgroundColorAttribute(String foBackgroundColorValue) {
    FoBackgroundColorAttribute attr =
        new FoBackgroundColorAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foBackgroundColorValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoColorAttribute</code> , See
   * {@odf.attribute fo:color}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoColorAttribute() {
    FoColorAttribute attr = (FoColorAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "color");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoColorAttribute</code> , See
   * {@odf.attribute fo:color}
   *
   * @param foColorValue The type is <code>String</code>
   */
  public void setFoColorAttribute(String foColorValue) {
    FoColorAttribute attr = new FoColorAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foColorValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoCountryAttribute</code> , See
   * {@odf.attribute fo:country}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoCountryAttribute() {
    FoCountryAttribute attr =
        (FoCountryAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "country");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoCountryAttribute</code> , See
   * {@odf.attribute fo:country}
   *
   * @param foCountryValue The type is <code>String</code>
   */
  public void setFoCountryAttribute(String foCountryValue) {
    FoCountryAttribute attr = new FoCountryAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foCountryValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoFontFamilyAttribute</code> ,
   * See {@odf.attribute fo:font-family}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoFontFamilyAttribute() {
    FoFontFamilyAttribute attr =
        (FoFontFamilyAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "font-family");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoFontFamilyAttribute</code> , See
   * {@odf.attribute fo:font-family}
   *
   * @param foFontFamilyValue The type is <code>String</code>
   */
  public void setFoFontFamilyAttribute(String foFontFamilyValue) {
    FoFontFamilyAttribute attr = new FoFontFamilyAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foFontFamilyValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoFontSizeAttribute</code> ,
   * See {@odf.attribute fo:font-size}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoFontSizeAttribute() {
    FoFontSizeAttribute attr =
        (FoFontSizeAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "font-size");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoFontSizeAttribute</code> , See
   * {@odf.attribute fo:font-size}
   *
   * @param foFontSizeValue The type is <code>String</code>
   */
  public void setFoFontSizeAttribute(String foFontSizeValue) {
    FoFontSizeAttribute attr = new FoFontSizeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foFontSizeValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoFontStyleAttribute</code> ,
   * See {@odf.attribute fo:font-style}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoFontStyleAttribute() {
    FoFontStyleAttribute attr =
        (FoFontStyleAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "font-style");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoFontStyleAttribute</code> , See
   * {@odf.attribute fo:font-style}
   *
   * @param foFontStyleValue The type is <code>String</code>
   */
  public void setFoFontStyleAttribute(String foFontStyleValue) {
    FoFontStyleAttribute attr = new FoFontStyleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foFontStyleValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoFontVariantAttribute</code> ,
   * See {@odf.attribute fo:font-variant}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoFontVariantAttribute() {
    FoFontVariantAttribute attr =
        (FoFontVariantAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "font-variant");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoFontVariantAttribute</code> , See
   * {@odf.attribute fo:font-variant}
   *
   * @param foFontVariantValue The type is <code>String</code>
   */
  public void setFoFontVariantAttribute(String foFontVariantValue) {
    FoFontVariantAttribute attr = new FoFontVariantAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foFontVariantValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoFontWeightAttribute</code> ,
   * See {@odf.attribute fo:font-weight}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoFontWeightAttribute() {
    FoFontWeightAttribute attr =
        (FoFontWeightAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "font-weight");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoFontWeightAttribute</code> , See
   * {@odf.attribute fo:font-weight}
   *
   * @param foFontWeightValue The type is <code>String</code>
   */
  public void setFoFontWeightAttribute(String foFontWeightValue) {
    FoFontWeightAttribute attr = new FoFontWeightAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foFontWeightValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoHyphenateAttribute</code> ,
   * See {@odf.attribute fo:hyphenate}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getFoHyphenateAttribute() {
    FoHyphenateAttribute attr =
        (FoHyphenateAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "hyphenate");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoHyphenateAttribute</code> , See
   * {@odf.attribute fo:hyphenate}
   *
   * @param foHyphenateValue The type is <code>Boolean</code>
   */
  public void setFoHyphenateAttribute(Boolean foHyphenateValue) {
    FoHyphenateAttribute attr = new FoHyphenateAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(foHyphenateValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * FoHyphenationPushCharCountAttribute</code> , See {@odf.attribute
   * fo:hyphenation-push-char-count}
   *
   * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Integer getFoHyphenationPushCharCountAttribute() {
    FoHyphenationPushCharCountAttribute attr =
        (FoHyphenationPushCharCountAttribute)
            getOdfAttribute(OdfDocumentNamespace.FO, "hyphenation-push-char-count");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Integer.valueOf(attr.intValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoHyphenationPushCharCountAttribute
   * </code> , See {@odf.attribute fo:hyphenation-push-char-count}
   *
   * @param foHyphenationPushCharCountValue The type is <code>Integer</code>
   */
  public void setFoHyphenationPushCharCountAttribute(Integer foHyphenationPushCharCountValue) {
    FoHyphenationPushCharCountAttribute attr =
        new FoHyphenationPushCharCountAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setIntValue(foHyphenationPushCharCountValue.intValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * FoHyphenationRemainCharCountAttribute</code> , See {@odf.attribute
   * fo:hyphenation-remain-char-count}
   *
   * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Integer getFoHyphenationRemainCharCountAttribute() {
    FoHyphenationRemainCharCountAttribute attr =
        (FoHyphenationRemainCharCountAttribute)
            getOdfAttribute(OdfDocumentNamespace.FO, "hyphenation-remain-char-count");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Integer.valueOf(attr.intValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoHyphenationRemainCharCountAttribute
   * </code> , See {@odf.attribute fo:hyphenation-remain-char-count}
   *
   * @param foHyphenationRemainCharCountValue The type is <code>Integer</code>
   */
  public void setFoHyphenationRemainCharCountAttribute(Integer foHyphenationRemainCharCountValue) {
    FoHyphenationRemainCharCountAttribute attr =
        new FoHyphenationRemainCharCountAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setIntValue(foHyphenationRemainCharCountValue.intValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoLanguageAttribute</code> ,
   * See {@odf.attribute fo:language}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoLanguageAttribute() {
    FoLanguageAttribute attr =
        (FoLanguageAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "language");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoLanguageAttribute</code> , See
   * {@odf.attribute fo:language}
   *
   * @param foLanguageValue The type is <code>String</code>
   */
  public void setFoLanguageAttribute(String foLanguageValue) {
    FoLanguageAttribute attr = new FoLanguageAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foLanguageValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoLetterSpacingAttribute</code>
   * , See {@odf.attribute fo:letter-spacing}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoLetterSpacingAttribute() {
    FoLetterSpacingAttribute attr =
        (FoLetterSpacingAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "letter-spacing");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoLetterSpacingAttribute</code> , See
   * {@odf.attribute fo:letter-spacing}
   *
   * @param foLetterSpacingValue The type is <code>String</code>
   */
  public void setFoLetterSpacingAttribute(String foLetterSpacingValue) {
    FoLetterSpacingAttribute attr = new FoLetterSpacingAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foLetterSpacingValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoScriptAttribute</code> , See
   * {@odf.attribute fo:script}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoScriptAttribute() {
    FoScriptAttribute attr = (FoScriptAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "script");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoScriptAttribute</code> , See
   * {@odf.attribute fo:script}
   *
   * @param foScriptValue The type is <code>String</code>
   */
  public void setFoScriptAttribute(String foScriptValue) {
    FoScriptAttribute attr = new FoScriptAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foScriptValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoTextShadowAttribute</code> ,
   * See {@odf.attribute fo:text-shadow}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoTextShadowAttribute() {
    FoTextShadowAttribute attr =
        (FoTextShadowAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "text-shadow");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoTextShadowAttribute</code> , See
   * {@odf.attribute fo:text-shadow}
   *
   * @param foTextShadowValue The type is <code>String</code>
   */
  public void setFoTextShadowAttribute(String foTextShadowValue) {
    FoTextShadowAttribute attr = new FoTextShadowAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foTextShadowValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoTextTransformAttribute</code>
   * , See {@odf.attribute fo:text-transform}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoTextTransformAttribute() {
    FoTextTransformAttribute attr =
        (FoTextTransformAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "text-transform");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoTextTransformAttribute</code> , See
   * {@odf.attribute fo:text-transform}
   *
   * @param foTextTransformValue The type is <code>String</code>
   */
  public void setFoTextTransformAttribute(String foTextTransformValue) {
    FoTextTransformAttribute attr = new FoTextTransformAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foTextTransformValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleCountryAsianAttribute
   * </code> , See {@odf.attribute style:country-asian}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleCountryAsianAttribute() {
    StyleCountryAsianAttribute attr =
        (StyleCountryAsianAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "country-asian");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleCountryAsianAttribute</code> , See
   * {@odf.attribute style:country-asian}
   *
   * @param styleCountryAsianValue The type is <code>String</code>
   */
  public void setStyleCountryAsianAttribute(String styleCountryAsianValue) {
    StyleCountryAsianAttribute attr =
        new StyleCountryAsianAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleCountryAsianValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleCountryComplexAttribute
   * </code> , See {@odf.attribute style:country-complex}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleCountryComplexAttribute() {
    StyleCountryComplexAttribute attr =
        (StyleCountryComplexAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "country-complex");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleCountryComplexAttribute</code> ,
   * See {@odf.attribute style:country-complex}
   *
   * @param styleCountryComplexValue The type is <code>String</code>
   */
  public void setStyleCountryComplexAttribute(String styleCountryComplexValue) {
    StyleCountryComplexAttribute attr =
        new StyleCountryComplexAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleCountryComplexValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontCharsetAttribute
   * </code> , See {@odf.attribute style:font-charset}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontCharsetAttribute() {
    StyleFontCharsetAttribute attr =
        (StyleFontCharsetAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "font-charset");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontCharsetAttribute</code> , See
   * {@odf.attribute style:font-charset}
   *
   * @param styleFontCharsetValue The type is <code>String</code>
   */
  public void setStyleFontCharsetAttribute(String styleFontCharsetValue) {
    StyleFontCharsetAttribute attr = new StyleFontCharsetAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontCharsetValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontCharsetAsianAttribute
   * </code> , See {@odf.attribute style:font-charset-asian}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontCharsetAsianAttribute() {
    StyleFontCharsetAsianAttribute attr =
        (StyleFontCharsetAsianAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-charset-asian");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontCharsetAsianAttribute</code> ,
   * See {@odf.attribute style:font-charset-asian}
   *
   * @param styleFontCharsetAsianValue The type is <code>String</code>
   */
  public void setStyleFontCharsetAsianAttribute(String styleFontCharsetAsianValue) {
    StyleFontCharsetAsianAttribute attr =
        new StyleFontCharsetAsianAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontCharsetAsianValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleFontCharsetComplexAttribute</code> , See {@odf.attribute style:font-charset-complex}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontCharsetComplexAttribute() {
    StyleFontCharsetComplexAttribute attr =
        (StyleFontCharsetComplexAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-charset-complex");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontCharsetComplexAttribute</code>
   * , See {@odf.attribute style:font-charset-complex}
   *
   * @param styleFontCharsetComplexValue The type is <code>String</code>
   */
  public void setStyleFontCharsetComplexAttribute(String styleFontCharsetComplexValue) {
    StyleFontCharsetComplexAttribute attr =
        new StyleFontCharsetComplexAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontCharsetComplexValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontFamilyAsianAttribute
   * </code> , See {@odf.attribute style:font-family-asian}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontFamilyAsianAttribute() {
    StyleFontFamilyAsianAttribute attr =
        (StyleFontFamilyAsianAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-family-asian");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontFamilyAsianAttribute</code> ,
   * See {@odf.attribute style:font-family-asian}
   *
   * @param styleFontFamilyAsianValue The type is <code>String</code>
   */
  public void setStyleFontFamilyAsianAttribute(String styleFontFamilyAsianValue) {
    StyleFontFamilyAsianAttribute attr =
        new StyleFontFamilyAsianAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontFamilyAsianValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontFamilyComplexAttribute
   * </code> , See {@odf.attribute style:font-family-complex}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontFamilyComplexAttribute() {
    StyleFontFamilyComplexAttribute attr =
        (StyleFontFamilyComplexAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-family-complex");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontFamilyComplexAttribute</code>
   * , See {@odf.attribute style:font-family-complex}
   *
   * @param styleFontFamilyComplexValue The type is <code>String</code>
   */
  public void setStyleFontFamilyComplexAttribute(String styleFontFamilyComplexValue) {
    StyleFontFamilyComplexAttribute attr =
        new StyleFontFamilyComplexAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontFamilyComplexValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontFamilyGenericAttribute
   * </code> , See {@odf.attribute style:font-family-generic}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontFamilyGenericAttribute() {
    StyleFontFamilyGenericAttribute attr =
        (StyleFontFamilyGenericAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-family-generic");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontFamilyGenericAttribute</code>
   * , See {@odf.attribute style:font-family-generic}
   *
   * @param styleFontFamilyGenericValue The type is <code>String</code>
   */
  public void setStyleFontFamilyGenericAttribute(String styleFontFamilyGenericValue) {
    StyleFontFamilyGenericAttribute attr =
        new StyleFontFamilyGenericAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontFamilyGenericValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleFontFamilyGenericAsianAttribute</code> , See {@odf.attribute
   * style:font-family-generic-asian}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontFamilyGenericAsianAttribute() {
    StyleFontFamilyGenericAsianAttribute attr =
        (StyleFontFamilyGenericAsianAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-family-generic-asian");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontFamilyGenericAsianAttribute
   * </code> , See {@odf.attribute style:font-family-generic-asian}
   *
   * @param styleFontFamilyGenericAsianValue The type is <code>String</code>
   */
  public void setStyleFontFamilyGenericAsianAttribute(String styleFontFamilyGenericAsianValue) {
    StyleFontFamilyGenericAsianAttribute attr =
        new StyleFontFamilyGenericAsianAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontFamilyGenericAsianValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleFontFamilyGenericComplexAttribute</code> , See {@odf.attribute
   * style:font-family-generic-complex}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontFamilyGenericComplexAttribute() {
    StyleFontFamilyGenericComplexAttribute attr =
        (StyleFontFamilyGenericComplexAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-family-generic-complex");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontFamilyGenericComplexAttribute
   * </code> , See {@odf.attribute style:font-family-generic-complex}
   *
   * @param styleFontFamilyGenericComplexValue The type is <code>String</code>
   */
  public void setStyleFontFamilyGenericComplexAttribute(String styleFontFamilyGenericComplexValue) {
    StyleFontFamilyGenericComplexAttribute attr =
        new StyleFontFamilyGenericComplexAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontFamilyGenericComplexValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontNameAttribute</code> ,
   * See {@odf.attribute style:font-name}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontNameAttribute() {
    StyleFontNameAttribute attr =
        (StyleFontNameAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "font-name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontNameAttribute</code> , See
   * {@odf.attribute style:font-name}
   *
   * @param styleFontNameValue The type is <code>String</code>
   */
  public void setStyleFontNameAttribute(String styleFontNameValue) {
    StyleFontNameAttribute attr = new StyleFontNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontNameAsianAttribute
   * </code> , See {@odf.attribute style:font-name-asian}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontNameAsianAttribute() {
    StyleFontNameAsianAttribute attr =
        (StyleFontNameAsianAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-name-asian");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontNameAsianAttribute</code> ,
   * See {@odf.attribute style:font-name-asian}
   *
   * @param styleFontNameAsianValue The type is <code>String</code>
   */
  public void setStyleFontNameAsianAttribute(String styleFontNameAsianValue) {
    StyleFontNameAsianAttribute attr =
        new StyleFontNameAsianAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontNameAsianValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontNameComplexAttribute
   * </code> , See {@odf.attribute style:font-name-complex}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontNameComplexAttribute() {
    StyleFontNameComplexAttribute attr =
        (StyleFontNameComplexAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-name-complex");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontNameComplexAttribute</code> ,
   * See {@odf.attribute style:font-name-complex}
   *
   * @param styleFontNameComplexValue The type is <code>String</code>
   */
  public void setStyleFontNameComplexAttribute(String styleFontNameComplexValue) {
    StyleFontNameComplexAttribute attr =
        new StyleFontNameComplexAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontNameComplexValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontPitchAttribute</code>
   * , See {@odf.attribute style:font-pitch}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontPitchAttribute() {
    StyleFontPitchAttribute attr =
        (StyleFontPitchAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "font-pitch");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontPitchAttribute</code> , See
   * {@odf.attribute style:font-pitch}
   *
   * @param styleFontPitchValue The type is <code>String</code>
   */
  public void setStyleFontPitchAttribute(String styleFontPitchValue) {
    StyleFontPitchAttribute attr = new StyleFontPitchAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontPitchValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontPitchAsianAttribute
   * </code> , See {@odf.attribute style:font-pitch-asian}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontPitchAsianAttribute() {
    StyleFontPitchAsianAttribute attr =
        (StyleFontPitchAsianAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-pitch-asian");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontPitchAsianAttribute</code> ,
   * See {@odf.attribute style:font-pitch-asian}
   *
   * @param styleFontPitchAsianValue The type is <code>String</code>
   */
  public void setStyleFontPitchAsianAttribute(String styleFontPitchAsianValue) {
    StyleFontPitchAsianAttribute attr =
        new StyleFontPitchAsianAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontPitchAsianValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontPitchComplexAttribute
   * </code> , See {@odf.attribute style:font-pitch-complex}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontPitchComplexAttribute() {
    StyleFontPitchComplexAttribute attr =
        (StyleFontPitchComplexAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-pitch-complex");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontPitchComplexAttribute</code> ,
   * See {@odf.attribute style:font-pitch-complex}
   *
   * @param styleFontPitchComplexValue The type is <code>String</code>
   */
  public void setStyleFontPitchComplexAttribute(String styleFontPitchComplexValue) {
    StyleFontPitchComplexAttribute attr =
        new StyleFontPitchComplexAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontPitchComplexValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontReliefAttribute</code>
   * , See {@odf.attribute style:font-relief}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontReliefAttribute() {
    StyleFontReliefAttribute attr =
        (StyleFontReliefAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "font-relief");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontReliefAttribute</code> , See
   * {@odf.attribute style:font-relief}
   *
   * @param styleFontReliefValue The type is <code>String</code>
   */
  public void setStyleFontReliefAttribute(String styleFontReliefValue) {
    StyleFontReliefAttribute attr = new StyleFontReliefAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontReliefValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontSizeAsianAttribute
   * </code> , See {@odf.attribute style:font-size-asian}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontSizeAsianAttribute() {
    StyleFontSizeAsianAttribute attr =
        (StyleFontSizeAsianAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-size-asian");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontSizeAsianAttribute</code> ,
   * See {@odf.attribute style:font-size-asian}
   *
   * @param styleFontSizeAsianValue The type is <code>String</code>
   */
  public void setStyleFontSizeAsianAttribute(String styleFontSizeAsianValue) {
    StyleFontSizeAsianAttribute attr =
        new StyleFontSizeAsianAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontSizeAsianValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontSizeComplexAttribute
   * </code> , See {@odf.attribute style:font-size-complex}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontSizeComplexAttribute() {
    StyleFontSizeComplexAttribute attr =
        (StyleFontSizeComplexAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-size-complex");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontSizeComplexAttribute</code> ,
   * See {@odf.attribute style:font-size-complex}
   *
   * @param styleFontSizeComplexValue The type is <code>String</code>
   */
  public void setStyleFontSizeComplexAttribute(String styleFontSizeComplexValue) {
    StyleFontSizeComplexAttribute attr =
        new StyleFontSizeComplexAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontSizeComplexValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontSizeRelAttribute
   * </code> , See {@odf.attribute style:font-size-rel}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontSizeRelAttribute() {
    StyleFontSizeRelAttribute attr =
        (StyleFontSizeRelAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "font-size-rel");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontSizeRelAttribute</code> , See
   * {@odf.attribute style:font-size-rel}
   *
   * @param styleFontSizeRelValue The type is <code>String</code>
   */
  public void setStyleFontSizeRelAttribute(String styleFontSizeRelValue) {
    StyleFontSizeRelAttribute attr = new StyleFontSizeRelAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontSizeRelValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontSizeRelAsianAttribute
   * </code> , See {@odf.attribute style:font-size-rel-asian}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontSizeRelAsianAttribute() {
    StyleFontSizeRelAsianAttribute attr =
        (StyleFontSizeRelAsianAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-size-rel-asian");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontSizeRelAsianAttribute</code> ,
   * See {@odf.attribute style:font-size-rel-asian}
   *
   * @param styleFontSizeRelAsianValue The type is <code>String</code>
   */
  public void setStyleFontSizeRelAsianAttribute(String styleFontSizeRelAsianValue) {
    StyleFontSizeRelAsianAttribute attr =
        new StyleFontSizeRelAsianAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontSizeRelAsianValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleFontSizeRelComplexAttribute</code> , See {@odf.attribute style:font-size-rel-complex}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontSizeRelComplexAttribute() {
    StyleFontSizeRelComplexAttribute attr =
        (StyleFontSizeRelComplexAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-size-rel-complex");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontSizeRelComplexAttribute</code>
   * , See {@odf.attribute style:font-size-rel-complex}
   *
   * @param styleFontSizeRelComplexValue The type is <code>String</code>
   */
  public void setStyleFontSizeRelComplexAttribute(String styleFontSizeRelComplexValue) {
    StyleFontSizeRelComplexAttribute attr =
        new StyleFontSizeRelComplexAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontSizeRelComplexValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontStyleAsianAttribute
   * </code> , See {@odf.attribute style:font-style-asian}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontStyleAsianAttribute() {
    StyleFontStyleAsianAttribute attr =
        (StyleFontStyleAsianAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-style-asian");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontStyleAsianAttribute</code> ,
   * See {@odf.attribute style:font-style-asian}
   *
   * @param styleFontStyleAsianValue The type is <code>String</code>
   */
  public void setStyleFontStyleAsianAttribute(String styleFontStyleAsianValue) {
    StyleFontStyleAsianAttribute attr =
        new StyleFontStyleAsianAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontStyleAsianValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontStyleComplexAttribute
   * </code> , See {@odf.attribute style:font-style-complex}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontStyleComplexAttribute() {
    StyleFontStyleComplexAttribute attr =
        (StyleFontStyleComplexAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-style-complex");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontStyleComplexAttribute</code> ,
   * See {@odf.attribute style:font-style-complex}
   *
   * @param styleFontStyleComplexValue The type is <code>String</code>
   */
  public void setStyleFontStyleComplexAttribute(String styleFontStyleComplexValue) {
    StyleFontStyleComplexAttribute attr =
        new StyleFontStyleComplexAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontStyleComplexValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontStyleNameAttribute
   * </code> , See {@odf.attribute style:font-style-name}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontStyleNameAttribute() {
    StyleFontStyleNameAttribute attr =
        (StyleFontStyleNameAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-style-name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontStyleNameAttribute</code> ,
   * See {@odf.attribute style:font-style-name}
   *
   * @param styleFontStyleNameValue The type is <code>String</code>
   */
  public void setStyleFontStyleNameAttribute(String styleFontStyleNameValue) {
    StyleFontStyleNameAttribute attr =
        new StyleFontStyleNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontStyleNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleFontStyleNameAsianAttribute</code> , See {@odf.attribute style:font-style-name-asian}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontStyleNameAsianAttribute() {
    StyleFontStyleNameAsianAttribute attr =
        (StyleFontStyleNameAsianAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-style-name-asian");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontStyleNameAsianAttribute</code>
   * , See {@odf.attribute style:font-style-name-asian}
   *
   * @param styleFontStyleNameAsianValue The type is <code>String</code>
   */
  public void setStyleFontStyleNameAsianAttribute(String styleFontStyleNameAsianValue) {
    StyleFontStyleNameAsianAttribute attr =
        new StyleFontStyleNameAsianAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontStyleNameAsianValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleFontStyleNameComplexAttribute</code> , See {@odf.attribute style:font-style-name-complex}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontStyleNameComplexAttribute() {
    StyleFontStyleNameComplexAttribute attr =
        (StyleFontStyleNameComplexAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-style-name-complex");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontStyleNameComplexAttribute
   * </code> , See {@odf.attribute style:font-style-name-complex}
   *
   * @param styleFontStyleNameComplexValue The type is <code>String</code>
   */
  public void setStyleFontStyleNameComplexAttribute(String styleFontStyleNameComplexValue) {
    StyleFontStyleNameComplexAttribute attr =
        new StyleFontStyleNameComplexAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontStyleNameComplexValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontWeightAsianAttribute
   * </code> , See {@odf.attribute style:font-weight-asian}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontWeightAsianAttribute() {
    StyleFontWeightAsianAttribute attr =
        (StyleFontWeightAsianAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-weight-asian");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontWeightAsianAttribute</code> ,
   * See {@odf.attribute style:font-weight-asian}
   *
   * @param styleFontWeightAsianValue The type is <code>String</code>
   */
  public void setStyleFontWeightAsianAttribute(String styleFontWeightAsianValue) {
    StyleFontWeightAsianAttribute attr =
        new StyleFontWeightAsianAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontWeightAsianValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleFontWeightComplexAttribute
   * </code> , See {@odf.attribute style:font-weight-complex}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleFontWeightComplexAttribute() {
    StyleFontWeightComplexAttribute attr =
        (StyleFontWeightComplexAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-weight-complex");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleFontWeightComplexAttribute</code>
   * , See {@odf.attribute style:font-weight-complex}
   *
   * @param styleFontWeightComplexValue The type is <code>String</code>
   */
  public void setStyleFontWeightComplexAttribute(String styleFontWeightComplexValue) {
    StyleFontWeightComplexAttribute attr =
        new StyleFontWeightComplexAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleFontWeightComplexValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleLanguageAsianAttribute
   * </code> , See {@odf.attribute style:language-asian}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleLanguageAsianAttribute() {
    StyleLanguageAsianAttribute attr =
        (StyleLanguageAsianAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "language-asian");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleLanguageAsianAttribute</code> ,
   * See {@odf.attribute style:language-asian}
   *
   * @param styleLanguageAsianValue The type is <code>String</code>
   */
  public void setStyleLanguageAsianAttribute(String styleLanguageAsianValue) {
    StyleLanguageAsianAttribute attr =
        new StyleLanguageAsianAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleLanguageAsianValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleLanguageComplexAttribute
   * </code> , See {@odf.attribute style:language-complex}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleLanguageComplexAttribute() {
    StyleLanguageComplexAttribute attr =
        (StyleLanguageComplexAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "language-complex");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleLanguageComplexAttribute</code> ,
   * See {@odf.attribute style:language-complex}
   *
   * @param styleLanguageComplexValue The type is <code>String</code>
   */
  public void setStyleLanguageComplexAttribute(String styleLanguageComplexValue) {
    StyleLanguageComplexAttribute attr =
        new StyleLanguageComplexAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleLanguageComplexValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleLetterKerningAttribute
   * </code> , See {@odf.attribute style:letter-kerning}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getStyleLetterKerningAttribute() {
    StyleLetterKerningAttribute attr =
        (StyleLetterKerningAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "letter-kerning");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleLetterKerningAttribute</code> ,
   * See {@odf.attribute style:letter-kerning}
   *
   * @param styleLetterKerningValue The type is <code>Boolean</code>
   */
  public void setStyleLetterKerningAttribute(Boolean styleLetterKerningValue) {
    StyleLetterKerningAttribute attr =
        new StyleLetterKerningAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(styleLetterKerningValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleRfcLanguageTagAttribute
   * </code> , See {@odf.attribute style:rfc-language-tag}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleRfcLanguageTagAttribute() {
    StyleRfcLanguageTagAttribute attr =
        (StyleRfcLanguageTagAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "rfc-language-tag");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleRfcLanguageTagAttribute</code> ,
   * See {@odf.attribute style:rfc-language-tag}
   *
   * @param styleRfcLanguageTagValue The type is <code>String</code>
   */
  public void setStyleRfcLanguageTagAttribute(String styleRfcLanguageTagValue) {
    StyleRfcLanguageTagAttribute attr =
        new StyleRfcLanguageTagAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleRfcLanguageTagValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleRfcLanguageTagAsianAttribute</code> , See {@odf.attribute style:rfc-language-tag-asian}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleRfcLanguageTagAsianAttribute() {
    StyleRfcLanguageTagAsianAttribute attr =
        (StyleRfcLanguageTagAsianAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "rfc-language-tag-asian");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleRfcLanguageTagAsianAttribute
   * </code> , See {@odf.attribute style:rfc-language-tag-asian}
   *
   * @param styleRfcLanguageTagAsianValue The type is <code>String</code>
   */
  public void setStyleRfcLanguageTagAsianAttribute(String styleRfcLanguageTagAsianValue) {
    StyleRfcLanguageTagAsianAttribute attr =
        new StyleRfcLanguageTagAsianAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleRfcLanguageTagAsianValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleRfcLanguageTagComplexAttribute</code> , See {@odf.attribute
   * style:rfc-language-tag-complex}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleRfcLanguageTagComplexAttribute() {
    StyleRfcLanguageTagComplexAttribute attr =
        (StyleRfcLanguageTagComplexAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "rfc-language-tag-complex");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleRfcLanguageTagComplexAttribute
   * </code> , See {@odf.attribute style:rfc-language-tag-complex}
   *
   * @param styleRfcLanguageTagComplexValue The type is <code>String</code>
   */
  public void setStyleRfcLanguageTagComplexAttribute(String styleRfcLanguageTagComplexValue) {
    StyleRfcLanguageTagComplexAttribute attr =
        new StyleRfcLanguageTagComplexAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleRfcLanguageTagComplexValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleScriptAsianAttribute
   * </code> , See {@odf.attribute style:script-asian}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleScriptAsianAttribute() {
    StyleScriptAsianAttribute attr =
        (StyleScriptAsianAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "script-asian");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleScriptAsianAttribute</code> , See
   * {@odf.attribute style:script-asian}
   *
   * @param styleScriptAsianValue The type is <code>String</code>
   */
  public void setStyleScriptAsianAttribute(String styleScriptAsianValue) {
    StyleScriptAsianAttribute attr = new StyleScriptAsianAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleScriptAsianValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleScriptComplexAttribute
   * </code> , See {@odf.attribute style:script-complex}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleScriptComplexAttribute() {
    StyleScriptComplexAttribute attr =
        (StyleScriptComplexAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "script-complex");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleScriptComplexAttribute</code> ,
   * See {@odf.attribute style:script-complex}
   *
   * @param styleScriptComplexValue The type is <code>String</code>
   */
  public void setStyleScriptComplexAttribute(String styleScriptComplexValue) {
    StyleScriptComplexAttribute attr =
        new StyleScriptComplexAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleScriptComplexValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleScriptTypeAttribute</code>
   * , See {@odf.attribute style:script-type}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleScriptTypeAttribute() {
    StyleScriptTypeAttribute attr =
        (StyleScriptTypeAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "script-type");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleScriptTypeAttribute</code> , See
   * {@odf.attribute style:script-type}
   *
   * @param styleScriptTypeValue The type is <code>String</code>
   */
  public void setStyleScriptTypeAttribute(String styleScriptTypeValue) {
    StyleScriptTypeAttribute attr = new StyleScriptTypeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleScriptTypeValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextBlinkingAttribute
   * </code> , See {@odf.attribute style:text-blinking}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getStyleTextBlinkingAttribute() {
    StyleTextBlinkingAttribute attr =
        (StyleTextBlinkingAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "text-blinking");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextBlinkingAttribute</code> , See
   * {@odf.attribute style:text-blinking}
   *
   * @param styleTextBlinkingValue The type is <code>Boolean</code>
   */
  public void setStyleTextBlinkingAttribute(Boolean styleTextBlinkingValue) {
    StyleTextBlinkingAttribute attr =
        new StyleTextBlinkingAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(styleTextBlinkingValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextCombineAttribute
   * </code> , See {@odf.attribute style:text-combine}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextCombineAttribute() {
    StyleTextCombineAttribute attr =
        (StyleTextCombineAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "text-combine");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextCombineAttribute</code> , See
   * {@odf.attribute style:text-combine}
   *
   * @param styleTextCombineValue The type is <code>String</code>
   */
  public void setStyleTextCombineAttribute(String styleTextCombineValue) {
    StyleTextCombineAttribute attr = new StyleTextCombineAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextCombineValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleTextCombineEndCharAttribute</code> , See {@odf.attribute style:text-combine-end-char}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextCombineEndCharAttribute() {
    StyleTextCombineEndCharAttribute attr =
        (StyleTextCombineEndCharAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-combine-end-char");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextCombineEndCharAttribute</code>
   * , See {@odf.attribute style:text-combine-end-char}
   *
   * @param styleTextCombineEndCharValue The type is <code>String</code>
   */
  public void setStyleTextCombineEndCharAttribute(String styleTextCombineEndCharValue) {
    StyleTextCombineEndCharAttribute attr =
        new StyleTextCombineEndCharAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextCombineEndCharValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleTextCombineStartCharAttribute</code> , See {@odf.attribute style:text-combine-start-char}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextCombineStartCharAttribute() {
    StyleTextCombineStartCharAttribute attr =
        (StyleTextCombineStartCharAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-combine-start-char");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextCombineStartCharAttribute
   * </code> , See {@odf.attribute style:text-combine-start-char}
   *
   * @param styleTextCombineStartCharValue The type is <code>String</code>
   */
  public void setStyleTextCombineStartCharAttribute(String styleTextCombineStartCharValue) {
    StyleTextCombineStartCharAttribute attr =
        new StyleTextCombineStartCharAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextCombineStartCharValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextEmphasizeAttribute
   * </code> , See {@odf.attribute style:text-emphasize}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextEmphasizeAttribute() {
    StyleTextEmphasizeAttribute attr =
        (StyleTextEmphasizeAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "text-emphasize");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextEmphasizeAttribute</code> ,
   * See {@odf.attribute style:text-emphasize}
   *
   * @param styleTextEmphasizeValue The type is <code>String</code>
   */
  public void setStyleTextEmphasizeAttribute(String styleTextEmphasizeValue) {
    StyleTextEmphasizeAttribute attr =
        new StyleTextEmphasizeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextEmphasizeValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleTextLineThroughColorAttribute</code> , See {@odf.attribute style:text-line-through-color}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextLineThroughColorAttribute() {
    StyleTextLineThroughColorAttribute attr =
        (StyleTextLineThroughColorAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-line-through-color");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextLineThroughColorAttribute
   * </code> , See {@odf.attribute style:text-line-through-color}
   *
   * @param styleTextLineThroughColorValue The type is <code>String</code>
   */
  public void setStyleTextLineThroughColorAttribute(String styleTextLineThroughColorValue) {
    StyleTextLineThroughColorAttribute attr =
        new StyleTextLineThroughColorAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextLineThroughColorValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleTextLineThroughModeAttribute</code> , See {@odf.attribute style:text-line-through-mode}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextLineThroughModeAttribute() {
    StyleTextLineThroughModeAttribute attr =
        (StyleTextLineThroughModeAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-line-through-mode");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextLineThroughModeAttribute
   * </code> , See {@odf.attribute style:text-line-through-mode}
   *
   * @param styleTextLineThroughModeValue The type is <code>String</code>
   */
  public void setStyleTextLineThroughModeAttribute(String styleTextLineThroughModeValue) {
    StyleTextLineThroughModeAttribute attr =
        new StyleTextLineThroughModeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextLineThroughModeValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleTextLineThroughStyleAttribute</code> , See {@odf.attribute style:text-line-through-style}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextLineThroughStyleAttribute() {
    StyleTextLineThroughStyleAttribute attr =
        (StyleTextLineThroughStyleAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-line-through-style");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextLineThroughStyleAttribute
   * </code> , See {@odf.attribute style:text-line-through-style}
   *
   * @param styleTextLineThroughStyleValue The type is <code>String</code>
   */
  public void setStyleTextLineThroughStyleAttribute(String styleTextLineThroughStyleValue) {
    StyleTextLineThroughStyleAttribute attr =
        new StyleTextLineThroughStyleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextLineThroughStyleValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleTextLineThroughTextAttribute</code> , See {@odf.attribute style:text-line-through-text}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextLineThroughTextAttribute() {
    StyleTextLineThroughTextAttribute attr =
        (StyleTextLineThroughTextAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-line-through-text");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextLineThroughTextAttribute
   * </code> , See {@odf.attribute style:text-line-through-text}
   *
   * @param styleTextLineThroughTextValue The type is <code>String</code>
   */
  public void setStyleTextLineThroughTextAttribute(String styleTextLineThroughTextValue) {
    StyleTextLineThroughTextAttribute attr =
        new StyleTextLineThroughTextAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextLineThroughTextValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleTextLineThroughTextStyleAttribute</code> , See {@odf.attribute
   * style:text-line-through-text-style}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextLineThroughTextStyleAttribute() {
    StyleTextLineThroughTextStyleAttribute attr =
        (StyleTextLineThroughTextStyleAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-line-through-text-style");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextLineThroughTextStyleAttribute
   * </code> , See {@odf.attribute style:text-line-through-text-style}
   *
   * @param styleTextLineThroughTextStyleValue The type is <code>String</code>
   */
  public void setStyleTextLineThroughTextStyleAttribute(String styleTextLineThroughTextStyleValue) {
    StyleTextLineThroughTextStyleAttribute attr =
        new StyleTextLineThroughTextStyleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextLineThroughTextStyleValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleTextLineThroughTypeAttribute</code> , See {@odf.attribute style:text-line-through-type}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextLineThroughTypeAttribute() {
    StyleTextLineThroughTypeAttribute attr =
        (StyleTextLineThroughTypeAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-line-through-type");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextLineThroughTypeAttribute
   * </code> , See {@odf.attribute style:text-line-through-type}
   *
   * @param styleTextLineThroughTypeValue The type is <code>String</code>
   */
  public void setStyleTextLineThroughTypeAttribute(String styleTextLineThroughTypeValue) {
    StyleTextLineThroughTypeAttribute attr =
        new StyleTextLineThroughTypeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextLineThroughTypeValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleTextLineThroughWidthAttribute</code> , See {@odf.attribute style:text-line-through-width}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextLineThroughWidthAttribute() {
    StyleTextLineThroughWidthAttribute attr =
        (StyleTextLineThroughWidthAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-line-through-width");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextLineThroughWidthAttribute
   * </code> , See {@odf.attribute style:text-line-through-width}
   *
   * @param styleTextLineThroughWidthValue The type is <code>String</code>
   */
  public void setStyleTextLineThroughWidthAttribute(String styleTextLineThroughWidthValue) {
    StyleTextLineThroughWidthAttribute attr =
        new StyleTextLineThroughWidthAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextLineThroughWidthValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextOutlineAttribute
   * </code> , See {@odf.attribute style:text-outline}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getStyleTextOutlineAttribute() {
    StyleTextOutlineAttribute attr =
        (StyleTextOutlineAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "text-outline");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextOutlineAttribute</code> , See
   * {@odf.attribute style:text-outline}
   *
   * @param styleTextOutlineValue The type is <code>Boolean</code>
   */
  public void setStyleTextOutlineAttribute(Boolean styleTextOutlineValue) {
    StyleTextOutlineAttribute attr = new StyleTextOutlineAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(styleTextOutlineValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextOverlineColorAttribute
   * </code> , See {@odf.attribute style:text-overline-color}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextOverlineColorAttribute() {
    StyleTextOverlineColorAttribute attr =
        (StyleTextOverlineColorAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-overline-color");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextOverlineColorAttribute</code>
   * , See {@odf.attribute style:text-overline-color}
   *
   * @param styleTextOverlineColorValue The type is <code>String</code>
   */
  public void setStyleTextOverlineColorAttribute(String styleTextOverlineColorValue) {
    StyleTextOverlineColorAttribute attr =
        new StyleTextOverlineColorAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextOverlineColorValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextOverlineModeAttribute
   * </code> , See {@odf.attribute style:text-overline-mode}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextOverlineModeAttribute() {
    StyleTextOverlineModeAttribute attr =
        (StyleTextOverlineModeAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-overline-mode");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextOverlineModeAttribute</code> ,
   * See {@odf.attribute style:text-overline-mode}
   *
   * @param styleTextOverlineModeValue The type is <code>String</code>
   */
  public void setStyleTextOverlineModeAttribute(String styleTextOverlineModeValue) {
    StyleTextOverlineModeAttribute attr =
        new StyleTextOverlineModeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextOverlineModeValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextOverlineStyleAttribute
   * </code> , See {@odf.attribute style:text-overline-style}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextOverlineStyleAttribute() {
    StyleTextOverlineStyleAttribute attr =
        (StyleTextOverlineStyleAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-overline-style");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextOverlineStyleAttribute</code>
   * , See {@odf.attribute style:text-overline-style}
   *
   * @param styleTextOverlineStyleValue The type is <code>String</code>
   */
  public void setStyleTextOverlineStyleAttribute(String styleTextOverlineStyleValue) {
    StyleTextOverlineStyleAttribute attr =
        new StyleTextOverlineStyleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextOverlineStyleValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextOverlineTypeAttribute
   * </code> , See {@odf.attribute style:text-overline-type}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextOverlineTypeAttribute() {
    StyleTextOverlineTypeAttribute attr =
        (StyleTextOverlineTypeAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-overline-type");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextOverlineTypeAttribute</code> ,
   * See {@odf.attribute style:text-overline-type}
   *
   * @param styleTextOverlineTypeValue The type is <code>String</code>
   */
  public void setStyleTextOverlineTypeAttribute(String styleTextOverlineTypeValue) {
    StyleTextOverlineTypeAttribute attr =
        new StyleTextOverlineTypeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextOverlineTypeValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextOverlineWidthAttribute
   * </code> , See {@odf.attribute style:text-overline-width}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextOverlineWidthAttribute() {
    StyleTextOverlineWidthAttribute attr =
        (StyleTextOverlineWidthAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-overline-width");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextOverlineWidthAttribute</code>
   * , See {@odf.attribute style:text-overline-width}
   *
   * @param styleTextOverlineWidthValue The type is <code>String</code>
   */
  public void setStyleTextOverlineWidthAttribute(String styleTextOverlineWidthValue) {
    StyleTextOverlineWidthAttribute attr =
        new StyleTextOverlineWidthAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextOverlineWidthValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextPositionAttribute
   * </code> , See {@odf.attribute style:text-position}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextPositionAttribute() {
    StyleTextPositionAttribute attr =
        (StyleTextPositionAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "text-position");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextPositionAttribute</code> , See
   * {@odf.attribute style:text-position}
   *
   * @param styleTextPositionValue The type is <code>String</code>
   */
  public void setStyleTextPositionAttribute(String styleTextPositionValue) {
    StyleTextPositionAttribute attr =
        new StyleTextPositionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextPositionValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextRotationAngleAttribute
   * </code> , See {@odf.attribute style:text-rotation-angle}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextRotationAngleAttribute() {
    StyleTextRotationAngleAttribute attr =
        (StyleTextRotationAngleAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-rotation-angle");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextRotationAngleAttribute</code>
   * , See {@odf.attribute style:text-rotation-angle}
   *
   * @param styleTextRotationAngleValue The type is <code>String</code>
   */
  public void setStyleTextRotationAngleAttribute(String styleTextRotationAngleValue) {
    StyleTextRotationAngleAttribute attr =
        new StyleTextRotationAngleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextRotationAngleValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextRotationScaleAttribute
   * </code> , See {@odf.attribute style:text-rotation-scale}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextRotationScaleAttribute() {
    StyleTextRotationScaleAttribute attr =
        (StyleTextRotationScaleAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-rotation-scale");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextRotationScaleAttribute</code>
   * , See {@odf.attribute style:text-rotation-scale}
   *
   * @param styleTextRotationScaleValue The type is <code>String</code>
   */
  public void setStyleTextRotationScaleAttribute(String styleTextRotationScaleValue) {
    StyleTextRotationScaleAttribute attr =
        new StyleTextRotationScaleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextRotationScaleValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextScaleAttribute</code>
   * , See {@odf.attribute style:text-scale}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextScaleAttribute() {
    StyleTextScaleAttribute attr =
        (StyleTextScaleAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "text-scale");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextScaleAttribute</code> , See
   * {@odf.attribute style:text-scale}
   *
   * @param styleTextScaleValue The type is <code>String</code>
   */
  public void setStyleTextScaleAttribute(String styleTextScaleValue) {
    StyleTextScaleAttribute attr = new StyleTextScaleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextScaleValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleTextUnderlineColorAttribute</code> , See {@odf.attribute style:text-underline-color}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextUnderlineColorAttribute() {
    StyleTextUnderlineColorAttribute attr =
        (StyleTextUnderlineColorAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-underline-color");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextUnderlineColorAttribute</code>
   * , See {@odf.attribute style:text-underline-color}
   *
   * @param styleTextUnderlineColorValue The type is <code>String</code>
   */
  public void setStyleTextUnderlineColorAttribute(String styleTextUnderlineColorValue) {
    StyleTextUnderlineColorAttribute attr =
        new StyleTextUnderlineColorAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextUnderlineColorValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextUnderlineModeAttribute
   * </code> , See {@odf.attribute style:text-underline-mode}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextUnderlineModeAttribute() {
    StyleTextUnderlineModeAttribute attr =
        (StyleTextUnderlineModeAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-underline-mode");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextUnderlineModeAttribute</code>
   * , See {@odf.attribute style:text-underline-mode}
   *
   * @param styleTextUnderlineModeValue The type is <code>String</code>
   */
  public void setStyleTextUnderlineModeAttribute(String styleTextUnderlineModeValue) {
    StyleTextUnderlineModeAttribute attr =
        new StyleTextUnderlineModeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextUnderlineModeValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleTextUnderlineStyleAttribute</code> , See {@odf.attribute style:text-underline-style}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextUnderlineStyleAttribute() {
    StyleTextUnderlineStyleAttribute attr =
        (StyleTextUnderlineStyleAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-underline-style");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextUnderlineStyleAttribute</code>
   * , See {@odf.attribute style:text-underline-style}
   *
   * @param styleTextUnderlineStyleValue The type is <code>String</code>
   */
  public void setStyleTextUnderlineStyleAttribute(String styleTextUnderlineStyleValue) {
    StyleTextUnderlineStyleAttribute attr =
        new StyleTextUnderlineStyleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextUnderlineStyleValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextUnderlineTypeAttribute
   * </code> , See {@odf.attribute style:text-underline-type}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextUnderlineTypeAttribute() {
    StyleTextUnderlineTypeAttribute attr =
        (StyleTextUnderlineTypeAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-underline-type");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextUnderlineTypeAttribute</code>
   * , See {@odf.attribute style:text-underline-type}
   *
   * @param styleTextUnderlineTypeValue The type is <code>String</code>
   */
  public void setStyleTextUnderlineTypeAttribute(String styleTextUnderlineTypeValue) {
    StyleTextUnderlineTypeAttribute attr =
        new StyleTextUnderlineTypeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextUnderlineTypeValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleTextUnderlineWidthAttribute</code> , See {@odf.attribute style:text-underline-width}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextUnderlineWidthAttribute() {
    StyleTextUnderlineWidthAttribute attr =
        (StyleTextUnderlineWidthAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-underline-width");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextUnderlineWidthAttribute</code>
   * , See {@odf.attribute style:text-underline-width}
   *
   * @param styleTextUnderlineWidthValue The type is <code>String</code>
   */
  public void setStyleTextUnderlineWidthAttribute(String styleTextUnderlineWidthValue) {
    StyleTextUnderlineWidthAttribute attr =
        new StyleTextUnderlineWidthAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextUnderlineWidthValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleUseWindowFontColorAttribute</code> , See {@odf.attribute style:use-window-font-color}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getStyleUseWindowFontColorAttribute() {
    StyleUseWindowFontColorAttribute attr =
        (StyleUseWindowFontColorAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "use-window-font-color");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleUseWindowFontColorAttribute</code>
   * , See {@odf.attribute style:use-window-font-color}
   *
   * @param styleUseWindowFontColorValue The type is <code>Boolean</code>
   */
  public void setStyleUseWindowFontColorAttribute(Boolean styleUseWindowFontColorValue) {
    StyleUseWindowFontColorAttribute attr =
        new StyleUseWindowFontColorAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(styleUseWindowFontColorValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextConditionAttribute</code> ,
   * See {@odf.attribute text:condition}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getTextConditionAttribute() {
    TextConditionAttribute attr =
        (TextConditionAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "condition");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextConditionAttribute</code> , See
   * {@odf.attribute text:condition}
   *
   * @param textConditionValue The type is <code>String</code>
   */
  public void setTextConditionAttribute(String textConditionValue) {
    TextConditionAttribute attr = new TextConditionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(textConditionValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextDisplayAttribute</code> ,
   * See {@odf.attribute text:display}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getTextDisplayAttribute() {
    TextDisplayAttribute attr =
        (TextDisplayAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "display");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextDisplayAttribute</code> , See
   * {@odf.attribute text:display}
   *
   * @param textDisplayValue The type is <code>String</code>
   */
  public void setTextDisplayAttribute(String textDisplayValue) {
    TextDisplayAttribute attr = new TextDisplayAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(textDisplayValue);
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }
}
