/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.table.TableFunctionAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableLinkToSourceDataAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableSourceCellRangeAddressesAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableTargetCellAddressAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableUseLabelsAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element table:consolidation}. */
public class TableConsolidationElement extends OdfElement {

  public static final OdfName ELEMENT_NAME =
      OdfName.newName(OdfDocumentNamespace.TABLE, "consolidation");

  /**
   * Create the instance of <code>TableConsolidationElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public TableConsolidationElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element table:consolidation}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TableFunctionAttribute</code> ,
   * See {@odf.attribute table:function}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getTableFunctionAttribute() {
    TableFunctionAttribute attr =
        (TableFunctionAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "function");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TableFunctionAttribute</code> , See
   * {@odf.attribute table:function}
   *
   * @param tableFunctionValue The type is <code>String</code>
   */
  public void setTableFunctionAttribute(String tableFunctionValue) {
    TableFunctionAttribute attr = new TableFunctionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(tableFunctionValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TableLinkToSourceDataAttribute
   * </code> , See {@odf.attribute table:link-to-source-data}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getTableLinkToSourceDataAttribute() {
    TableLinkToSourceDataAttribute attr =
        (TableLinkToSourceDataAttribute)
            getOdfAttribute(OdfDocumentNamespace.TABLE, "link-to-source-data");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(TableLinkToSourceDataAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TableLinkToSourceDataAttribute</code> ,
   * See {@odf.attribute table:link-to-source-data}
   *
   * @param tableLinkToSourceDataValue The type is <code>Boolean</code>
   */
  public void setTableLinkToSourceDataAttribute(Boolean tableLinkToSourceDataValue) {
    TableLinkToSourceDataAttribute attr =
        new TableLinkToSourceDataAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(tableLinkToSourceDataValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * TableSourceCellRangeAddressesAttribute</code> , See {@odf.attribute
   * table:source-cell-range-addresses}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getTableSourceCellRangeAddressesAttribute() {
    TableSourceCellRangeAddressesAttribute attr =
        (TableSourceCellRangeAddressesAttribute)
            getOdfAttribute(OdfDocumentNamespace.TABLE, "source-cell-range-addresses");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TableSourceCellRangeAddressesAttribute
   * </code> , See {@odf.attribute table:source-cell-range-addresses}
   *
   * @param tableSourceCellRangeAddressesValue The type is <code>String</code>
   */
  public void setTableSourceCellRangeAddressesAttribute(String tableSourceCellRangeAddressesValue) {
    TableSourceCellRangeAddressesAttribute attr =
        new TableSourceCellRangeAddressesAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(tableSourceCellRangeAddressesValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TableTargetCellAddressAttribute
   * </code> , See {@odf.attribute table:target-cell-address}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getTableTargetCellAddressAttribute() {
    TableTargetCellAddressAttribute attr =
        (TableTargetCellAddressAttribute)
            getOdfAttribute(OdfDocumentNamespace.TABLE, "target-cell-address");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TableTargetCellAddressAttribute</code>
   * , See {@odf.attribute table:target-cell-address}
   *
   * @param tableTargetCellAddressValue The type is <code>String</code>
   */
  public void setTableTargetCellAddressAttribute(String tableTargetCellAddressValue) {
    TableTargetCellAddressAttribute attr =
        new TableTargetCellAddressAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(tableTargetCellAddressValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TableUseLabelsAttribute</code>
   * , See {@odf.attribute table:use-labels}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getTableUseLabelsAttribute() {
    TableUseLabelsAttribute attr =
        (TableUseLabelsAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "use-labels");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return TableUseLabelsAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TableUseLabelsAttribute</code> , See
   * {@odf.attribute table:use-labels}
   *
   * @param tableUseLabelsValue The type is <code>String</code>
   */
  public void setTableUseLabelsAttribute(String tableUseLabelsValue) {
    TableUseLabelsAttribute attr = new TableUseLabelsAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(tableUseLabelsValue);
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }
}
