/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextConditionAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextIsHiddenAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStringValueAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element text:hidden-text}. */
public class TextHiddenTextElement extends OdfElement {

  public static final OdfName ELEMENT_NAME =
      OdfName.newName(OdfDocumentNamespace.TEXT, "hidden-text");

  /**
   * Create the instance of <code>TextHiddenTextElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public TextHiddenTextElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element text:hidden-text}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextConditionAttribute</code> ,
   * See {@odf.attribute text:condition}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getTextConditionAttribute() {
    TextConditionAttribute attr =
        (TextConditionAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "condition");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextConditionAttribute</code> , See
   * {@odf.attribute text:condition}
   *
   * @param textConditionValue The type is <code>String</code>
   */
  public void setTextConditionAttribute(String textConditionValue) {
    TextConditionAttribute attr = new TextConditionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(textConditionValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextIsHiddenAttribute</code> ,
   * See {@odf.attribute text:is-hidden}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getTextIsHiddenAttribute() {
    TextIsHiddenAttribute attr =
        (TextIsHiddenAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "is-hidden");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextIsHiddenAttribute</code> , See
   * {@odf.attribute text:is-hidden}
   *
   * @param textIsHiddenValue The type is <code>Boolean</code>
   */
  public void setTextIsHiddenAttribute(Boolean textIsHiddenValue) {
    TextIsHiddenAttribute attr = new TextIsHiddenAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(textIsHiddenValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextStringValueAttribute</code>
   * , See {@odf.attribute text:string-value}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getTextStringValueAttribute() {
    TextStringValueAttribute attr =
        (TextStringValueAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "string-value");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextStringValueAttribute</code> , See
   * {@odf.attribute text:string-value}
   *
   * @param textStringValueValue The type is <code>String</code>
   */
  public void setTextStringValueAttribute(String textStringValueValue) {
    TextStringValueAttribute attr = new TextStringValueAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(textStringValueValue);
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }

  /** Add text content. Only elements which are allowed to have text content offer this method. */
  public void newTextNode(String content) {
    if (content != null && !content.equals("")) {
      this.appendChild(this.getOwnerDocument().createTextNode(content));
    }
  }
}
