/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextStyleNameAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element text:index-title-template}. */
public class TextIndexTitleTemplateElement extends OdfStylableElement {

  public static final OdfName ELEMENT_NAME =
      OdfName.newName(OdfDocumentNamespace.TEXT, "index-title-template");

  /**
   * Create the instance of <code>TextIndexTitleTemplateElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public TextIndexTitleTemplateElement(OdfFileDom ownerDoc) {
    super(
        ownerDoc,
        ELEMENT_NAME,
        OdfStyleFamily.Paragraph,
        OdfName.newName(OdfDocumentNamespace.TEXT, "style-name"));
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element
   *     text:index-title-template}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextStyleNameAttribute</code> ,
   * See {@odf.attribute text:style-name}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getTextStyleNameAttribute() {
    TextStyleNameAttribute attr =
        (TextStyleNameAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "style-name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextStyleNameAttribute</code> , See
   * {@odf.attribute text:style-name}
   *
   * @param textStyleNameValue The type is <code>String</code>
   */
  public void setTextStyleNameAttribute(String textStyleNameValue) {
    TextStyleNameAttribute attr = new TextStyleNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(textStyleNameValue);
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }

  /** Add text content. Only elements which are allowed to have text content offer this method. */
  public void newTextNode(String content) {
    if (content != null && !content.equals("")) {
      this.appendChild(this.getOwnerDocument().createTextNode(content));
    }
  }

  /**
   * Splitting the element at the given position into two halves
   *
   * <p>If the paragraph does have an automatic style with a master-page, which results into a page
   * break before the paragraph, this page break will be removed for the new second half. For
   * paragraph containing template styles the follow-up style should be chosen.
   *
   * @param posStart The logical position of the first character (or other paragraph child
   *     component) that will be moved to the beginning of the new paragraph.
   * @return the new created second text container
   */
  @Override
  public OdfElement split(int posStart) {
    TextParagraphElementBase newSecondElement = (TextParagraphElementBase) super.split(posStart);
    OdfStyle autoStyle = newSecondElement.getAutomaticStyle();

    if (autoStyle != null) {
      OdfStylePropertiesBase paragraphProps =
          autoStyle.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties);
      if (autoStyle.getStyleMasterPageNameAttribute() != null || paragraphProps != null) {
        StyleStyleElement newStyle = newSecondElement.getOrCreateUnqiueAutomaticStyle();
        if (autoStyle.getStyleMasterPageNameAttribute() != null) {
          newStyle.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "master-page-name");
        }
        // overwrite the paragraph properties from the source one, with the cloned element's
        paragraphProps = newStyle.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties);
        // no paragraph page break should be inherited
        if (paragraphProps != null) {
          paragraphProps.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "break-before");
          paragraphProps.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "break-after");
        }
      }
    }
    return newSecondElement;
  }
}
