/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextStartValueAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStyleOverrideAttribute;
import org.odftoolkit.odfdom.dom.attribute.xml.XmlIdAttribute;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextNumberElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSoftPageBreakElement;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Node;

public class TextListItemElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "list-item");

    public TextListItemElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public Integer getTextStartValueAttribute() {
        TextStartValueAttribute attr = (TextStartValueAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "start-value");
        if (attr != null && !attr.getValue().isEmpty()) {
            return attr.intValue();
        }
        return null;
    }

    public void setTextStartValueAttribute(Integer textStartValueValue) {
        TextStartValueAttribute attr = new TextStartValueAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setIntValue(textStartValueValue);
    }

    public String getTextStyleOverrideAttribute() {
        TextStyleOverrideAttribute attr = (TextStyleOverrideAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "style-override");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextStyleOverrideAttribute(String textStyleOverrideValue) {
        TextStyleOverrideAttribute attr = new TextStyleOverrideAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textStyleOverrideValue);
    }

    public String getXmlIdAttribute() {
        XmlIdAttribute attr = (XmlIdAttribute)this.getOdfAttribute(OdfDocumentNamespace.XML, "id");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setXmlIdAttribute(String xmlIdValue) {
        XmlIdAttribute attr = new XmlIdAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(xmlIdValue);
    }

    public TextHElement newTextHElement(int textOutlineLevelValue) {
        TextHElement textH = ((OdfFileDom)this.ownerDocument).newOdfElement(TextHElement.class);
        textH.setTextOutlineLevelAttribute(textOutlineLevelValue);
        this.appendChild((Node)((Object)textH));
        return textH;
    }

    public TextListElement newTextListElement() {
        TextListElement textList = ((OdfFileDom)this.ownerDocument).newOdfElement(TextListElement.class);
        this.appendChild((Node)((Object)textList));
        return textList;
    }

    public TextNumberElement newTextNumberElement() {
        TextNumberElement textNumber = ((OdfFileDom)this.ownerDocument).newOdfElement(TextNumberElement.class);
        this.appendChild((Node)((Object)textNumber));
        return textNumber;
    }

    public TextPElement newTextPElement() {
        TextPElement textP = ((OdfFileDom)this.ownerDocument).newOdfElement(TextPElement.class);
        this.appendChild((Node)((Object)textP));
        return textP;
    }

    public TextSoftPageBreakElement newTextSoftPageBreakElement() {
        TextSoftPageBreakElement textSoftPageBreak = ((OdfFileDom)this.ownerDocument).newOdfElement(TextSoftPageBreakElement.class);
        this.appendChild((Node)((Object)textSoftPageBreak));
        return textSoftPageBreak;
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }
}

