/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDisplayNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextConsecutiveNumberingAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleBulletElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleImageElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleNumberElement;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Node;

public class TextListStyleElement
extends OdfStyleBase {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "list-style");

    public TextListStyleElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getStyleDisplayNameAttribute() {
        StyleDisplayNameAttribute attr = (StyleDisplayNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "display-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setStyleDisplayNameAttribute(String styleDisplayNameValue) {
        StyleDisplayNameAttribute attr = new StyleDisplayNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(styleDisplayNameValue);
    }

    public String getStyleNameAttribute() {
        StyleNameAttribute attr = (StyleNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setStyleNameAttribute(String styleNameValue) {
        StyleNameAttribute attr = new StyleNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(styleNameValue);
    }

    public Boolean getTextConsecutiveNumberingAttribute() {
        TextConsecutiveNumberingAttribute attr = (TextConsecutiveNumberingAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "consecutive-numbering");
        if (attr != null && !attr.getValue().isEmpty()) {
            return attr.booleanValue();
        }
        return Boolean.valueOf("false");
    }

    public void setTextConsecutiveNumberingAttribute(Boolean textConsecutiveNumberingValue) {
        TextConsecutiveNumberingAttribute attr = new TextConsecutiveNumberingAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setBooleanValue(textConsecutiveNumberingValue);
    }

    public TextListLevelStyleBulletElement newTextListLevelStyleBulletElement(String textBulletCharValue, int textLevelValue) {
        TextListLevelStyleBulletElement textListLevelStyleBullet = ((OdfFileDom)this.ownerDocument).newOdfElement(TextListLevelStyleBulletElement.class);
        textListLevelStyleBullet.setTextBulletCharAttribute(textBulletCharValue);
        textListLevelStyleBullet.setTextLevelAttribute(textLevelValue);
        this.appendChild((Node)((Object)textListLevelStyleBullet));
        return textListLevelStyleBullet;
    }

    public TextListLevelStyleImageElement newTextListLevelStyleImageElement(int textLevelValue) {
        TextListLevelStyleImageElement textListLevelStyleImage = ((OdfFileDom)this.ownerDocument).newOdfElement(TextListLevelStyleImageElement.class);
        textListLevelStyleImage.setTextLevelAttribute(textLevelValue);
        this.appendChild((Node)((Object)textListLevelStyleImage));
        return textListLevelStyleImage;
    }

    public TextListLevelStyleNumberElement newTextListLevelStyleNumberElement(String styleNumFormatValue, int textLevelValue) {
        TextListLevelStyleNumberElement textListLevelStyleNumber = ((OdfFileDom)this.ownerDocument).newOdfElement(TextListLevelStyleNumberElement.class);
        textListLevelStyleNumber.setStyleNumFormatAttribute(styleNumFormatValue);
        textListLevelStyleNumber.setTextLevelAttribute(textLevelValue);
        this.appendChild((Node)((Object)textListLevelStyleNumber));
        return textListLevelStyleNumber;
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }
}

