/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Node;

public class TextPElement
extends TextParagraphElementBase {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "p");

    public TextPElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME, OdfStyleFamily.Paragraph, OdfName.newName(OdfDocumentNamespace.TEXT, "style-name"));
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    public void newTextNode(String content) {
        if (content != null && !content.equals("")) {
            this.appendChild(this.getOwnerDocument().createTextNode(content));
        }
    }

    public void setTextContent(String content) {
        super.setTextContent(content);
        ((OdfFileDom)this.ownerDocument).updateInContentMetadataCache((Node)((Object)this));
    }

    @Override
    protected void onRemoveNode() {
        super.onRemoveNode();
        ((OdfFileDom)this.ownerDocument).getInContentMetadataCache().remove(this);
    }

    @Override
    protected void onInsertNode() {
        super.onInsertNode();
        ((OdfFileDom)this.ownerDocument).updateInContentMetadataCache((Node)((Object)this));
    }

    @Override
    public boolean isComponentRoot() {
        return true;
    }

    @Override
    public OdfElement split(int posStart) {
        TextParagraphElementBase newSecondElement = (TextParagraphElementBase)super.split(posStart);
        OdfStyle autoStyle = newSecondElement.getAutomaticStyle();
        if (autoStyle != null) {
            OdfStylePropertiesBase paragraphProps = autoStyle.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties);
            if (autoStyle.getStyleMasterPageNameAttribute() != null || paragraphProps != null) {
                StyleStyleElement newStyle = newSecondElement.getOrCreateUnqiueAutomaticStyle();
                if (autoStyle.getStyleMasterPageNameAttribute() != null) {
                    newStyle.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "master-page-name");
                }
                if ((paragraphProps = newStyle.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties)) != null) {
                    paragraphProps.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "break-before");
                    paragraphProps.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "break-after");
                }
            }
        }
        return newSecondElement;
    }
}

