/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextListStyleElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfListLevelProperties;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextListLevelStyleBullet;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextListLevelStyleNumber;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

public class OdfTextListStyle
extends TextListStyleElement {
    private static final long serialVersionUID = -5493176392198676430L;
    protected static final int MAX_LIST_LEVEL = 10;
    public static final boolean SHOW_ALL_LEVELS = true;
    public static final boolean SHOW_ONE_LEVEL = false;

    public OdfTextListStyle(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfTextListStyle(OdfFileDom ownerDoc, String name, String specifiers, String delim, String spacing, boolean showAllLevels) {
        super(ownerDoc);
        String[] specArray = specifiers.split(delim);
        this.newListStyle(name, specArray, spacing, showAllLevels);
    }

    public OdfTextListStyle(OdfFileDom ownerDoc, String name, String[] specArray, String spacing, boolean showAllLevels) {
        super(ownerDoc);
        this.newListStyle(name, specArray, spacing, showAllLevels);
    }

    public TextListLevelStyleElementBase getLevel(int level) {
        for (Node levelElement = this.getFirstChild(); levelElement != null; levelElement = levelElement.getNextSibling()) {
            if (!(levelElement instanceof TextListLevelStyleElementBase)) continue;
            if (level == 1) {
                return (TextListLevelStyleElementBase)((Object)levelElement);
            }
            --level;
        }
        return null;
    }

    public TextListLevelStyleElementBase getOrCreateListLevel(int level, Class clazz) {
        TextListLevelStyleElementBase levelStyle = this.getLevel(level);
        if (levelStyle != null && clazz.isInstance(levelStyle)) {
            return levelStyle;
        }
        if (levelStyle != null) {
            this.removeChild((Node)((Object)levelStyle));
        }
        levelStyle = (TextListLevelStyleElementBase)((OdfFileDom)this.ownerDocument).newOdfElement(clazz);
        levelStyle.setTextLevelAttribute(level);
        this.appendChild((Node)((Object)levelStyle));
        return levelStyle;
    }

    @Override
    public OdfStyleFamily getFamily() {
        return OdfStyleFamily.List;
    }

    @Override
    public OdfStyleBase getParentStyle() {
        return null;
    }

    private void newListStyle(String name, String[] specArray, String spacing, boolean showAllLevels) {
        String cssLengthUnits;
        double cssLengthNum;
        Pattern numFormatPattern = Pattern.compile("([1IiAa])");
        Pattern cssLengthPattern = Pattern.compile("([^a-z]+)\\s*([a-z]+)?");
        String numPrefix = "";
        String numSuffix = "";
        String numberFormat = "";
        this.setStyleNameAttribute(name);
        Matcher m = cssLengthPattern.matcher(spacing);
        if (m.find()) {
            try {
                cssLengthNum = Double.parseDouble(m.group(1));
            }
            catch (NumberFormatException oops) {
                cssLengthNum = 0.0;
            }
            cssLengthUnits = m.group(2) == null ? "" : m.group(2);
        } else {
            cssLengthNum = 0.0;
            cssLengthUnits = "";
        }
        for (int i = 0; i < Math.min(specArray.length, 10); ++i) {
            TextListLevelStyleElementBase styleItem;
            specArray[i] = specArray[i].trim();
            m = numFormatPattern.matcher(specArray[i]);
            if (m.find()) {
                numberFormat = m.group(1);
                numPrefix = specArray[i].substring(0, m.start(1));
                numSuffix = specArray[i].substring(m.end(1));
                int displayLevels = showAllLevels ? i + 1 : 1;
                OdfTextListLevelStyleNumber number = new OdfTextListLevelStyleNumber((OdfFileDom)this.ownerDocument);
                number.setStyleNumPrefixAttribute(numPrefix);
                number.setStyleNumFormatAttribute(numberFormat);
                number.setStyleNumSuffixAttribute(numSuffix);
                number.setTextDisplayLevelsAttribute(displayLevels);
                styleItem = number;
            } else {
                OdfTextListLevelStyleBullet bullet = new OdfTextListLevelStyleBullet((OdfFileDom)this.ownerDocument);
                bullet.setStyleNumPrefixAttribute("");
                bullet.setStyleNumSuffixAttribute("");
                if (!specArray[i].equals("")) {
                    bullet.setTextBulletCharAttribute(specArray[i].substring(0, 1));
                } else {
                    bullet.setTextBulletCharAttribute("");
                }
                styleItem = bullet;
            }
            styleItem.setTextLevelAttribute(i + 1);
            styleItem.setProperty(OdfListLevelProperties.SpaceBefore, Double.toString(cssLengthNum * (double)(i + 1)) + cssLengthUnits);
            styleItem.setProperty(OdfListLevelProperties.MinLabelWidth, Double.toString(cssLengthNum) + cssLengthUnits);
            this.appendChild((Node)((Object)styleItem));
        }
    }

    @Override
    public String toString() {
        return this.getStyleNameAttribute();
    }
}

